<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

/**
 * 首页导航菜单
 * Class GoodsController
 * @package app\adminapi\controller\goods
 */
class Online extends BaseAdminController
{
    public function list()
    {

        $redis = \think\facade\Cache::store('redis')->handler();

        $prefix = 'user_online_*';

        $keys = $redis->keys($prefix);

        // 获取对应的值
        $online_count  = 0;
        
        $data = [];
        foreach($keys as $key){
            $temp = json_decode($redis->get($key),true);
            if(time() - $temp['time'] > 60*10){//超过10分钟的不显示
                continue;
            }
            $online_count+=1;
            $data[$key] = $temp;
            $data[$key]['online'] = checkOnline($data[$key]['user']['uid']);
        }
        
        $res = [
            'online_count' => $online_count,
            'list'=>$data,
        ];
        return show(config('status.success'),'在线列表',$res);

    }
}


