<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
declare (strict_types = 1);

namespace app\common\model;

use app\common\service\FileService;
use think\Model;

/**
 * @mixin \think\Model
 */
class TwoAfterSaleGoods extends Model
{
    public function afterSale()
    {
        return $this->hasOne(TwoAfterSale::class, 'id', 'after_sale_id');
    }

    /**
     * @notes 获取商品信息快照
     * @param $value
     * @return mixed
     */
    public function getGoodsSnapAttr($value)
    {
        $goodsSnap = TwoOrderGoods::where('id', $value)->find()->goods_snap;

        if(!empty($goodsSnap)) {
            // $goodsSnap = json_decode($goodsSnap, true);
            $goodsSnap['use_image'] = !empty($goodsSnap['spec_image']) ? $goodsSnap['spec_image'] : $goodsSnap['image'];
            $goodsSnap['use_image'] = FileService::getFileUrl($goodsSnap['use_image']);
            $goodsSnap['goods'] = TwoGoods::findOrEmpty($goodsSnap['goods_id']);
            $goodsSnap['user'] = User::field('id,nickname,avatar')->findOrEmpty($goodsSnap['user_id']);
        }
        return $goodsSnap;
    }
}
