<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\logic;

use app\common\enum\ActivityEnum;
use app\common\model\GoodsActivity;

/**
 * 商品活动信息
 */
class GoodsActivityLogic extends BaseLogic
{
    /**
     * @notes 获取商品活动信息
     * @param $goodsIds
     * @param $type 活动类型
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function activityInfo($goodsIds = [],$type = 0)
    {
        // 转数组
        if ($goodsIds && !is_array($goodsIds)) {
            $goodsIds = [$goodsIds];
        }
        $where = [];
        if($goodsIds){
            $where[] = ['goods_id','in',$goodsIds];
        }
        if($type){
            $where[] = ['activity_type','=',$type];
        }
        // 获取活动信息
        $lists = GoodsActivity::where($where)->select()->toArray();
        if (empty($lists)) {
            return [];
        }
        // 提取有参与活动的商品ids
        $goodsIds = array_column($lists, 'goods_id');
        $goodsIds = array_unique($goodsIds);

        // 生成初始化数据
        $data = [];
        foreach ($goodsIds as $goodsId) {
            $data[$goodsId] = [];
            foreach (ActivityEnum::TYPE as $type) {
                $data[$goodsId][$type]['type'] = $type;
                $data[$goodsId][$type]['activity_id'] = null;
                $data[$goodsId][$type]['item_id'] = [];
            }
        }

        // 填充活动信息
        foreach ($lists as $item) {
            $data[$item['goods_id']][$item['activity_type']]['activity_id'] = $item['activity_id'];
            $data[$item['goods_id']][$item['activity_type']]['item_id'][] = $item['item_id'];
        }

        // 去除没有活动信息的初始数据
        foreach($data as $key => $item) {
            foreach (ActivityEnum::TYPE as $type) {
                if (is_null($item[$type]['activity_id'])) {
                    unset($data[$key][$type]);
                }
            }
            if (empty($data[$key])) {
                unset($data[$key]);
            }
        }

        return $data;
    }
}