<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */



namespace app\common\enum;


/**
 * 运费
 * Class FreightEnum
 * @package app\common\enum
 */
class FreightEnum
{
    //计费方式
    const CHARGE_WAY_PIECE = 1;//按件计费
    const CHARGE_WAY_WEIGHT = 2;//按重量计费
    const CHARGE_WAY_VOLUME = 3; //体积计费

    /**
     * @notes 计算方式
     * @param bool $type
     * @return array|mixed|string
     */
    public static function getChargeWay($type = true)
    {
        $data = [
            self::CHARGE_WAY_PIECE  => '按件计费',
            self::CHARGE_WAY_WEIGHT => '按重量计费',
            self::CHARGE_WAY_VOLUME => '按体积计费',
        ];
        if (true === $type) {
            return $data;
        }
        return $data[$type] ?? '未知';
    }

}