<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\api\validate\UserAddressValidate;
use app\api\logic\UserAddressLogic;
use app\common\enum\YesNoEnum;


/**
 * 收货地址
 * Class UserAddressController
 * @package app\api\controller
 */
class UserAddress extends BaseShopController
{

    /**
     * @notes 列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->data(UserAddressLogic::getLists($this->userId));
    }


    /**
     * @notes 详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params = (new UserAddressValidate())->goCheck('detail', ['user_id' => $this->userId]);
        $result = UserAddressLogic::getDetail($params['id'], $this->userId);
        return $this->data($result);
    }


    /**
     * @notes 获取默认地址
     * @return \think\response\Json
     */
    public function getDefault()
    {
        $result = UserAddressLogic::getDefault($this->userId);
        return $this->data($result);
    }


    /**
     * @notes 设置默认地址
     * @return \think\response\Json
     */
    public function setDefault()
    {
        $params = (new UserAddressValidate())->post()->goCheck('set', ['user_id' => $this->userId]);
        UserAddressLogic::setDefault($params, $this->userId);
        return $this->success('设置成功',[],1,1);
    }


    /**
     * @notes 添加收货地址
     * @return \think\response\Json
     */
    public function add()
    {
        $params = (new UserAddressValidate())->post()->goCheck('add');
        UserAddressLogic::addAddress($params, $this->userId);
        return $this->success();
    }

    public function addWechat()
    {
        $params = $this->request->post();

        // consignee, mobile, province, city, region, detailAddress 判断不为空 存为变量 否则报错参数错误
        if (empty($params['consignee']) || empty($params['mobile']) || empty($params['province']) || empty($params['city']) || empty($params['region']) || empty($params['detailAddress'])) {
            return $this->fail('参数错误');
        }

        $consignee = $params['consignee'];
        $mobile = $params['mobile'];
        $province = $params['province'];
        $city = $params['city'];
        $region = $params['region'];
        $detailAddress = $params['detailAddress'];

        \app\common\model\UserAddress::create([
            'user_id'       => $this->userId,
            'contact'       => $consignee,
            'mobile'        => $mobile,
            'province_id'   => \app\common\model\Region::where('name|short', $province)->value('id'),
            'city_id'       => \app\common\model\Region::where('name|short', $city)->value('id'),
            'district_id'   => \app\common\model\Region::where('name|short', $region)->value('id'),
            'address'       => $detailAddress,
            'is_default'    => $params['is_default'] ?? YesNoEnum::NO,
            'create_time'   => time()
        ]);

        return $this->success();
    }


    /**
     * @notes 编辑收货地址
     * @return \think\response\Json
     */
    public function edit()
    {
        $params = (new UserAddressValidate())->post()->goCheck('', ['user_id' => $this->userId]);
        UserAddressLogic::editAddress($params);
        return $this->success();
    }


    /**
     * @notes 删除
     * @return \think\response\Json
     */
    public function del()
    {
        $params = (new UserAddressValidate())->post()->goCheck('del', ['user_id' => $this->userId]);
        UserAddressLogic::del($params);
        return $this->success();
    }

    /**
     * @notes 将省市区名称转为id
     * @return \think\response\Json
     */
    public function handleRegion()
    {
        $params = (new UserAddressValidate())->goCheck('handleRegion');
        $result = UserAddressLogic::handleRegion($params);
        return $this->data($result);
    }

    /**
     * @notes 获取省市区
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     * @author lgp
     * @date 2022/11/8 6:43 下午
     */
    public function getRegion()
    {
        $id = $this->request->get('id',0);
        $lists = UserAddressLogic::getRegion($id);
        return $this->data($lists);
    }
}