<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\goods;


use app\common\enum\DefaultEnum;
use app\common\model\GoodsUnit;

class GoodsUnitLogic
{
    /**
     * @notes 添加商品单位
     * @param $params
     * @return bool
     */
    public function add($params)
    {
        $goods_unit = new GoodsUnit;
        $goods_unit->name = $params['name'];
        $goods_unit->sort = (isset($params['sort']) && !empty($params['sort'])) ? $params['sort'] : DefaultEnum::SORT;
        return $goods_unit->save();
    }

    /**
     * @notes 删除商品单位
     * @param $params
     * @return bool
     */
    public function del($params)
    {
        return GoodsUnit::destroy($params['id']);
    }

    /**
     * @notes 编辑商品单位
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function edit($params)
    {
        $goods_unit = GoodsUnit::find($params['id']);
        $goods_unit->name = $params['name'];
        $goods_unit->sort = $params['sort'];
        return $goods_unit->save();
    }

    /**
     * @notes 查看商品单位详情
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail($params)
    {
        return GoodsUnit::find($params)->toArray();
    }
}