<?php

namespace app\adminapi\controller\user;

use app\adminapi\controller\BaseAdminController;

class LabelItem extends BaseAdminController
{
    public function list()
    {
        $params = $this->request->param();

        $where = [];

        if (isset($params['gid'])) {
            $where[] = [
                'group_id', '=', $params['gid']
            ];
        }

        $list = \app\common\model\UserLabelItem::order('sort DESC')
            ->where($where)
            ->select()
            ->toArray();

        return show(1, '', $list);
    }

    public function create()
    {
        $params = $this->request->post();
        $res = \app\common\model\UserLabelItem::create($params);
        if (!$res) {
            return show(0, '添加失败');
        };
        return show(1, '添加成功');
    }

    public function del($id)
    {
        \app\common\model\UserLabelItem::destroy($id);

        return show(config('status.success'), '删除成功');
    }

    public function detail($id)
    {
        $res = \app\common\model\UserLabelItem::where('id', $id)->find();
        if (!$res) {
            return show(0, '查询失败');
        };
        return show(1, '查询成功', $res);
    }


    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\UserLabelItem::where('id', $params['id'])->update($params);
        if (!$res) {
            return show(0, '修改失败');
        };
        return show(1, '修改成功');
    }
}