const css = document.createElement("link");
css.rel="stylesheet"
css.href="/build/layui.css"
document.head.appendChild(css);

const script = document.createElement("script");
script.src = "/build/layui.js"; // 需要引入的 JS 文件

// const layim = document.createElement("script");
// layim.src = "/build/layim.js"; // 需要引入的 JS 文件

var timer = null;
var layim = null;

script.onload = () => {
    executeAfterLoad();
};
// document.head.appendChild(layim);
document.head.appendChild(script);

function getUrlParams(url) {
  const paramsRegex = /[?&]+([^=&]+)=([^&]*)/gi;
  const params = {};
  let match;
  while (match = paramsRegex.exec(url)) {
    params[match[1]] = match[2];
  }
  return params;
}

function executeAfterLoad()
{
	// alert(0)
  if (!/^http(s*):\/\//.test(location.href)) {
      alert('请部署到localhost上查看该演示');
    }

    layui.use(['layim', 'jquery'], function (layim2) {
	layim = layim2;
      var $ = layui.jquery; // 引入 jQuery
		
      //建立WebSocket通讯
	  var token = window.localStorage.getItem("Token");
	  var host = window.localStorage.getItem("host");
	  var ws_host = window.localStorage.getItem("ws_host");
      var websocket = new WebSocket(ws_host+'/?token='+token+'&type=kefu');
	  var ticks = null;
	  var ticks2 = null;
      // 监听soket收发消息
       //监听收到的聊天消息
       websocket.onmessage = function(event){
		
        var data = JSON.parse(event.data)
		console.log('监听收到的聊天消息',data);
          if(data.event == 'chat' && data.data.from == "user"){ 
            data = data.data;
			console.log(host+data.from_avatar);
            obj = {
                username: data.nickname
                , avatar: data.avatar
                , id: data.user_id
                , type: data.type
                , content: data.msg
                , timestamp: new Date().getTime()
              }
            // 新收到消息通知
            layim.getMessage(obj);
			layim.addList(obj);
          }
        }
		var check = false;
		
		// ticks = setInterval(() => {
		// 	if(check == true){
		// 		console.log(100);
		// 		token = window.localStorage.getItem("Token");
		// 		host = window.localStorage.getItem("host");
		// 		ws_host = window.localStorage.getItem("ws_host");
		// 		websocket = new WebSocket(ws_host+'/?token='+token+'&type=kefu');
		// 	}
			 
		// }, 1000)
		
		
		websocket.onclose = function (event){
			
			setTimeout(() => {
				
				executeAfterLoad()
			}, 5000)
			
			check = true;
			// ticks = setInterval(() => {
			// 	 token = window.localStorage.getItem("Token");
			// 	 host = window.localStorage.getItem("host");
			// 	 ws_host = window.localStorage.getItem("ws_host");
			// 	 websocket = new WebSocket(ws_host+'/?token='+token+'&type=kefu');
			// }, 1000)
		}
		
		websocket.onerror= function (event){
			// executeAfterLoad()
			check = true;
			
			// ticks2 = setInterval(() => {
			// 	 token = window.localStorage.getItem("Token");
			// 	 host = window.localStorage.getItem("host");
			// 	 ws_host = window.localStorage.getItem("ws_host");
			// 	 websocket = new WebSocket(ws_host+'/?token='+token+'&type=kefu');
			// }, 1000)
		}
		
		websocket.onopen = function (e){
			check = false
			
		}


      //基础配置
      layim.config({

        //初始化接口
        init: {
          url: '/build/getList.json'
          , data: {}
        },

        //简约模式（不显示主面板）
        // ,brief: true

        min:true,

        //查看群员接口
        // members: {
        //   url: './json/getMembers.json'
        //   , data: {}
        // },

        title:"我的消息",

        uploadImage: {
          url: '' //（返回的数据格式见下文）
          , type: '' //默认post
        }

        , uploadFile: {
          url: '' //（返回的数据格式见下文）
          , type: '' //默认post
        },

        isfriend:false,
        isgroup:false,

        //,skin: ['aaa.jpg'] //新增皮肤
        //,isfriend: false //是否开启好友
        //,isgroup: false //是否开启群组
        // min: true, //是否始终最小化主面板（默认false）
        chatLog: './demo/chatlog.html' //聊天记录地址
        // , find: './demo/find.html'
        //,copyright: true //是否授权
      });
		
      // 初始化聊天记录
      $.ajax({
        url: host+"/adminapi/kefu.kefu/list?token="+token, // 你的后端接口地址
        type: "POST", // 请求类型（GET / POST）
        data: { id: 1 }, // 发送的数据
        dataType: "json", // 预期返回的数据格式
        success: function (res) {
          console.log('聊天记录', res); // 处理返回数据
          // layer.msg("请求成功！");
          if (res.code == 1) {
			  
            // res.data.forEach(element => {
            //   layim.chat({
            //     name: element.toUser.nickname
            //     , type: 'kefu'
            //     , avatar: element.toUser.avatar
            //     , id: element.toUser.id
            //   });
            // });
          }
        },
        error: function (err) {
          console.error(err);
          layer.msg("请求失败！");
        }
      });

      /*
      */
      //layim.setChatMin();

      //监听发送消息
      layim.on('sendMessage', function (data) {
		  
        var To = data.to;
        console.log('监听发送消息',data.mine.content);
        console.log('soket',websocket);
		console.log('To = data.to', To);
		$.ajax({
		  url: host+"/adminapi/kefu.kefu/sendMessage?token="+token, // 你的后端接口地址
		  type: "POST", // 请求类型（GET / POST）
		  data: { user_id: To.id, msg: data.mine.content, msg_type: 'text' }, // 发送的数据
		  dataType: "json", // 预期返回的数据格式
		  success: function (res) {
		    console.log("success data", res);
		  },
		  error: function (err) {
		    console.error(err);
		    layer.msg("请求失败！");
		  }
		});
		
		
        // let send_data = {
        //     "event":"chat",
        //     "data":{
        //         "msg":data.mine.content,
        //         "to_id":To.id,
        //         "msg_type":"text",
        //         "type":"private_chat",
        //     }
        // };
		
        // websocket.send(JSON.stringify(send_data));
      });

      //监听在线状态的切换事件
      layim.on('online', function (data) {
        console.log(data);
      });

      //layim建立就绪
      layim.on('ready', function (res) {
        //添加好友（如果检测到该socket）
        // layim.addList({
        //   type: 'group'
        //   , avatar: "http://tva3.sinaimg.cn/crop.64.106.361.361.50/7181dbb3jw8evfbtem8edj20ci0dpq3a.jpg"
        //   , groupname: 'Angular开发'
        //   , id: "12333333"
        //   , members: 0
        // });
        // layim.addList({
        //   type: 'friend'
        //   , avatar: "http://tp2.sinaimg.cn/2386568184/180/40050524279/0"
        //   , username: '冲田杏梨'
        //   , groupid: 2
        //   , id: "1233333312121212"
        //   , remark: "本人冲田杏梨将结束AV女优的工作"
        // });
      });

      //监听查看群员
      // layim.on('members', function (data) {
      //   console.log(data);
      // });

      //监听聊天窗口的切换
      layim.on('chatChange', function (data) {
        console.log(data);
      });



    });
}


