<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\service\sms\engine;

use AlibabaCloud\Client\AlibabaCloud;

/**
 * 阿里云短信
 * Class AliSms
 * @package app\common\service\sms\engine
 */
class DxbSms
{
    protected $error = null;
    protected $config;
    protected $mobile;
    protected $templateId;
    protected $templateParams;


    /**
     * @notes 架构方法
     * @param $config
     */
    public function __construct($config)
    {
        if(empty($config)) {
            $this->error = '请联系管理员配置参数';
            return false;
        }
        $this->config = $config;
    }

    /**
     * @notes 设置手机号
     * @param $mobile
     * @return $this
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;
        return $this;
    }

    /**
     * @notes 设置模板id
     * @param $templateId
     * @return $this
     */
    public function setTemplateId($templateId)
    {
        $this->templateId = $templateId;
        return $this;
    }

    /**
     * @notes 设置模板参数
     * @param $templateParams
     * @return $this
     */
    public function setTemplateParams($templateParams)
    {
        // $this->templateParams = json_encode($templateParams, JSON_UNESCAPED_UNICODE);
        $this->templateParams = $templateParams;
        return $this;
    }

    /**
     * @notes 获取错误信息
     * @return mixed
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @notes 发送短信
     * @return false|mixed
     */
    public function send()
    {
        try {

            $result = \app\adminapi\logic\notice\NoticeLogic::detail(['id'=>1]);
            
            $statusStr = array(
                "0" => "短信发送成功",
                "-1" => "参数不全",
                "-2" => "服务器空间不支持,请确认支持curl或者fsocket，联系您的空间商解决或者更换空间！",
                "30" => "密码错误",
                "40" => "账号不存在",
                "41" => "余额不足",
                "42" => "帐户已过期",
                "43" => "IP地址限制",
                "50" => "内容含有敏感词"
                );
                $smsapi = "http://api.smsbao.com/";
                $user = $this->config['sign']; //短信平台帐号
                $pass = md5($this->config['secret_key']); //短信平台密码
                $content = str_replace('${code}',$this->templateParams['code'],$result['sms_notice']['content']);
                $phone =  $this->mobile;//要发送短信的手机号码
                $sendurl = $smsapi."sms?u=".$user."&p=".$pass."&m=".$phone."&c=".urlencode($content);
                $result =file_get_contents($sendurl) ;
            if ($result == 0) {
                return true;
            }

            $message = $statusStr[$result] ?? $result;
            throw new \Exception('阿里云短信错误：' . $message);
        } catch(\Exception $e) {
            $this->error = $e->getMessage();
            return false;
        }
    }
}