<?php
// 命名空间对应目录结构
namespace app\common\service;

// 引入PHPMailer相关类
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

class EmailService
{
    // 邮件发送方法
    public static function send($toEmail, $subject, $content, $isHtml = true)
    {

        $emailConfig = [
            'host'=> ConfigService::get('email', 'host', 'smtp.qq.com'),
            'port'=> ConfigService::get('email', 'port', '587'),
            'user'=> ConfigService::get('email', 'user', ''),
            'pass'=> ConfigService::get('email', 'pass', ''),
            'from_name'=> ConfigService::get('email', 'from_name', ''),
        ];
        
        // 实例化PHPMailer并启用异常处理
        $mail = new PHPMailer(true);

        try {
            // 1. 基础配置（SMTP服务器设置）
            $mail->SMTPDebug = SMTP::DEBUG_OFF; // 关闭调试模式（上线后保持关闭，调试时可改为DEBUG_SERVER）
            $mail->isSMTP(); // 使用SMTP协议发送
            $mail->Host       = $emailConfig['host']; // SMTP服务器地址（QQ邮箱：smtp.qq.com；163邮箱：smtp.163.com）
            $mail->SMTPAuth   = true; // 启用SMTP身份验证
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // 加密方式（SSL：SMTPS；TLS：ENCRYPTION_STARTTLS）
            $mail->Port       = $emailConfig['port']; // 对应加密方式的端口（SSL：465；TLS：587）

            // 2. 发件人配置（替换为你的实际信息）
            $mail->Username   = $emailConfig['user']; // 发件人邮箱账号
            $mail->Password   = $emailConfig['pass']; // SMTP授权码（非邮箱登录密码，需在邮箱后台开启SMTP后获取）
            $mail->setFrom($emailConfig['user'], $emailConfig['from_name']); // 发件人邮箱和昵称

            // 3. 收件人配置
            $mail->addAddress($toEmail); // 收件人邮箱（可多次调用addAddress添加多个收件人）
            // $mail->addCC('cc@example.com'); // 抄送（可选）
            // $mail->addBCC('bcc@example.com'); // 密送（可选）

            // 4. 邮件内容配置
            $mail->CharSet = 'UTF-8'; // 设置邮件编码，防止中文乱码
            $mail->isHTML($isHtml); // 是否以HTML格式发送（true：HTML格式；false：纯文本格式）
            $mail->Subject = $subject; // 邮件主题
            $mail->Body    = $content; // 邮件正文（HTML格式或纯文本）
            // $mail->AltBody = '纯文本备用内容（当收件人邮箱不支持HTML时显示）'; // 可选

            // 5. 发送邮件
            $mail->send();
            return true; // 发送成功返回true
        } catch (Exception $e) {
            // 发送失败返回错误信息
            return "邮件发送失败：{$mail->ErrorInfo}";
        }
    }
}