<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\service\FileService;
use think\model\concern\SoftDelete;

class OrderGoods extends BaseModel
{
    use SoftDelete;

    protected $deleteTime = 'delete_time';

    //订单商品快照(json)
    protected $json = ['goods_snap'];

    /**
     * @notes 订单商品图片获取器
     * @param $value
     * @param $data
     * @return mixed
     */
    public function getGoodsImageAttr($value, $data)
    {
        $goods_image = json_decode($data['goods_snap'],true)['image'];
        return empty($goods_image) ? '' : FileService::getFileUrl($goods_image);
    }

    /**
     * @notes 订单商品规格获取器
     * @param $value
     * @param $data
     * @return string
     */
    public function getSpecValueStrAttr($value, $data)
    {
        return json_decode($data['goods_snap'],true)['spec_value_str'];
    }

    /**
     * @notes 商品名称获取器
     * @param $value
     * @param $data
     * @return mixed
     */
    public function getGoodsNameAttr($value, $data)
    {
        return json_decode($data['goods_snap'],true)['goods_name'];
    }

    /**
     * @notes 商品编码
     * @param $value
     * @param $data
     * @return string
     */
    public function getCodeAttr($value, $data)
    {
        return $data['goods_snap']->code ?? '';
    }

    /**
     * @notes 商品原价
     * @param $value
     * @param $data
     * @return mixed
     */
    public function getOriginalPriceAttr($value, $data)
    {
        return $data['goods_snap']->original_price ?? 0;
    }
}