<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */



namespace app\common\enum;


/**
 * 支付
 * Class PayrEnum
 * @package app\common\enum
 */
class PayEnum
{


    //支付类型
    const BALANCE_PAY   = 1; //余额支付
    const WECHAT_PAY    = 2; //微信支付
    const ALI_PAY       = 3; //支付宝支付


    //支付状态
    const UNPAID = 0; //未支付
    const ISPAID = 1; //已支付


    //退款状态
    const NOT_REFUND = 0;//未退款
    const REFUND_ING = 1;//退款中
    const REFUND_SUCCESS = 1;//退款成功
    const REFUND_ERROR = 1;//退款失败

    //支付场景
    const SCENE_H5 = 3;//H5
    const SCENE_OA = 2;//微信公众号
    const SCENE_MNP = 1;//微信小程序
    const SCENE_APP = 4;//APP
    const SCENE_PC = 5;//PC


    /**
     * @notes 获取支付类型
     * @param bool $value
     * @return string|string[]
     */
    public static function getPayDesc($value = true)
    {
        $data = [
            self::BALANCE_PAY => '金币支付',
            self::WECHAT_PAY => '微信支付',
            self::ALI_PAY => '支付宝支付'
        ];
        if ($value === true) {
            return $data;
        }
        return $data[$value] ?? '';
    }

    /**
     * @notes 支付状态
     * @param bool $value
     * @return string|string[]
     */
    public static function getPayStatusDesc($value = true)
    {
        $data = [
            self::UNPAID => '未支付',
            self::ISPAID => '已支付',
        ];
        if ($value === true) {
            return $data;
        }
        return $data[$value] ?? '';
    }


    /**
     * @notes 支付场景
     * @param bool $value
     * @return string|string[]
     */
    public static function getPaySceneDesc($value = true)
    {
        $data = [
            self::SCENE_H5 => 'H5',
            self::SCENE_OA => '微信公众号',
            self::SCENE_APP => 'APP',
            self::SCENE_MNP => '微信小程序',
            self::SCENE_PC => 'PC',
        ];
        if ($value === true) {
            return $data;
        }
        return $data[$value] ?? '';
    }


}