<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\enum;

class DeliveryEnum
{
    //配送方式
    const EXPRESS_DELIVERY = 1;//快递发货


    //配送状态
    const NOT_SHIPPED = 0;//未发货
    const SHIPPED = 1;//已发货

    //发货方式
    const EXPRESS = 1;//快递配送
    const NO_EXPRESS = 2;//无需快递

    // 所有配送方式
    const DELIVERY_TYPE = [
        self::EXPRESS_DELIVERY
    ];


    /**
     * @notes 获取快递100对应的支付方式
     * @param null $payment
     * @return string|string[]
     */
    public static function getKuaidi100Desc($payment = null)
    {
        $desc = [
           
        ];
        if (is_null($payment)) {
            return $desc;
        }
        return $desc[$payment] ?? '';
    }

    /**
     * @notes 配送方式
     * @param bool $value
     * @return string|string[]
     */
    public static function getDeliveryTypeDesc($value = true)
    {
        $data = [
            self::EXPRESS_DELIVERY => '快递发货'
        ];
        if (true === $value) {
            return $data;
        }
        return $data[$value] ?? '';
    }

    /**
     * @notes 配送状态
     * @param bool $value
     * @return string|string[]
     */
    public static function getDeliveryStatusDesc($value = true)
    {
        $data = [
            self::NOT_SHIPPED => '未发货',
            self::SHIPPED => '已发货',
        ];
        if (true === $value) {
            return $data;
        }
        return $data[$value];
    }

    /**
     * @notes 发货方式
     * @param bool $value
     * @return string|string[]
     */
    public static function getSendTypeDesc($value = true)
    {
        $data = [
            self::EXPRESS => '快递配送',
            self::NO_EXPRESS => '无需快递',
        ];
        if (true === $value) {
            return $data;
        }
        return $data[$value];
    }
}