<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\enum\PayEnum;
use app\common\model\RechargeOrder;
use app\common\model\RechargeTemplate;

/**
 * 充值记录列表
 * Class RechargeLists
 * @package app\api\lists
 */
class RechargeLists extends BaseShopDataLists
{
    /**
     * @notes 充值成功记录列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $lists = RechargeOrder::field('order_amount,award,create_time')
            ->where([
                'user_id' => $this->userId,
                'pay_status' => PayEnum::ISPAID
            ])
            ->order('id', 'desc')
            ->select()
            ->toArray();

        foreach($lists as &$item) {
            $item['tips'] = $this->getTips($item);
        }

        return $lists;
    }

    /**
     * @notes 充值成功记录数
     * @return int
     */
    public function count(): int
    {
        $count = RechargeOrder::field('order_amount,award,create_time')
            ->where([
                'user_id' => $this->userId,
                'pay_status' => PayEnum::ISPAID
            ])
            ->count();

        return $count;
    }

    /**
     * @notes 获取充值赠送提示语
     * @param $item
     * @return string
     */
    public function getTips(&$item)
    {
        if(empty($item['award']) || !is_array($item['award'])) {
            return '充值' . clear_zero($item['order_amount']) . '元';
        }
        foreach($item['award'] as $subItem) {
            $tips = isset($subItem['give_money']) && $subItem['give_money'] > 0 ? '充' . clear_zero($item['order_amount']) . '送' . clear_zero($subItem['give_money']) . '元' : '';
            $item['order_amount'] += $subItem['give_money'];
            return $tips;
        }
    }
}