<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║
 *  ║                                                   ║
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\common\model\RealVerify;

class RealVerifyType extends BaseShopController
{
    public array $notNeedLogin = ['list'];

    public function list()
    {
        $list = \app\common\model\RealVerifyType::field('id,type,icon,name,create_time,update_time')
            ->where('status', 1)
            ->select()
            ->toArray();

        if ($this->request->param('with_status')) {
            foreach ($list as &$item) {
                $item['status'] = \app\common\model\RealVerify::where('user_id', $this->userId)
                    ->where('type_id', $item['id'])
                    ->value('status');
            }
        }

        return show(1, '列表', $list);
    }

    public function detail($id)
    {
        $res = \app\common\model\RealVerifyType::where('id', $id)->where('status', 1)->with('fields')->find();
        if (!$res) {
            return show(0, '查询失败');
        };
        $res = $res->toArray();
        return show(1, '查询成功', $res);
    }
}