<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;

use app\api\lists\OrderLists;
use app\api\logic\Order\OrderLogic;
use app\api\validate\PlaceOrderValidate;
use app\api\validate\OrderValidate;

/**
 * 订单
 * Class OrderController
 * @package app\api\controller
 */
class Order extends BaseShopController
{
    
    public array $notNeedLogin = ['getDeliveryType'];

    /**
     * @notes 提交订单/结算详情
     * @return \think\response\Json
     */
    public function placeOrder()
    {
        $data = [
            'terminal' => $this->userInfo['terminal'],
            'user_id'=> $this->userId
        ];
        $params = (new PlaceOrderValidate())->post()->goCheck('', $data);

        //订单结算信息
        $settlement = OrderLogic::settlement($params);
        if (false === $settlement) {
            return $this->fail(OrderLogic::getError());
        }
        //结算信息
        if ($params['action'] == 'settle') {
            return $this->data($settlement);
        }
        //提交订单
        $result = OrderLogic::submitOrder($settlement);
        if (false === $result) {
            return $this->fail(OrderLogic::getError());
        }
        return $this->data($result);
    }


    /**
     * @notes 订单列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists((new OrderLists()));
    }


    /**
     * @notes 订单详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params = (new OrderValidate())->goCheck('detail', ['user_id' => $this->userId]);
        return $this->data(OrderLogic::getDetail($params));
    }


    /**
     * @notes 取消订单
     * @return \think\response\Json
     */
    public function cancel()
    {
        $params = (new OrderValidate())->post()->goCheck('cancel', ['user_id' => $this->userId]);
        $result = OrderLogic::cancelOrder($params);
        if (false === $result) {
            return $this->fail(OrderLogic::getError());
        }
        return $this->success('取消订单成功');
    }

    /**
     * @notes 确认收货
     * @return \think\response\Json
     */
    public function confirm()
    {
        $params = (new OrderValidate())->post()->goCheck('confirm', ['user_id' => $this->userId]);
        OrderLogic::confirmOrder($params);
        return $this->success('确认收货成功');
    }

    /**
     * @notes 查看物流
     * @return \think\response\Json
     */
    public function orderTraces()
    {
        $params = (new OrderValidate())->goCheck('OrderTraces', ['user_id' => $this->userId]);
        $result = OrderLogic::orderTraces($params);
        return $this->data($result);
    }

    /**
     * @notes 获取配送方式
     * @return \think\response\Json
     */
    public function getDeliveryType()
    {
        $result = (new OrderLogic())->getDeliveryType();
        return $this->success('',$result);
    }

    /**
     * @notes 删除订单
     * @return \think\response\Json
     */
    public function del()
    {
        $params = (new OrderValidate())->post()->goCheck('del', ['user_id' => $this->userId]);
        (new OrderLogic())->del($params);
        return $this->success('删除成功',[],1,1);
    }

}