<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\adminapi\controller\user;
use app\adminapi\{
    validate\user\UserLevelValidate,
    logic\user\UserLevelLogic,
    controller\BaseAdminController,
};

/**
 * 会员等级控制器
 * Class UserLevelController
 * @package app\adminapi\controller\user
 */
class VipPackage extends BaseAdminController
{
    /**
     * @notes 会员套餐
     * @return \think\response\Json
     */
    public function list()
    {
        $where = [];
        $params = $this->request->get();
        if(isset($params['vip_level_id'])){
            $where[]=['vip_level_id','=',$params['vip_level_id']];
        }
        $list = \app\common\model\VipPackage::where($where)->select()->toArray();
        if($list){
            return show(config('status.success'),'列表',$list);
        }else{
            return show(config('status.error'),'查询失败');
        }
    }


    public function add()
    {
        $params = $this->request->post();
        $res = \app\common\model\VipPackage::create($params);
        if($res){
            return show(config('status.success'),'添加成功');
        }else{
            return show(config('status.error'),'未修改');
        }
    }

    public function update()
    {
        $params = request()->post();
        $res = \app\common\model\VipPackage::where('id', $params['id'])->update($params);
        if($res){
            return show(config('status.success'),'修改成功');
        }else{
            return show(config('status.error'),'修改失败');
        }
    }

    public function del()
    {
        $id = $this->request->get('id'); 
        $res =  \app\common\model\VipPackage::where('id', $id)->delete();
        if($res){
            return show(config('status.success'),'删除成功');
        }else{
            return show(config('status.error'),'删除失败');
        }
    }

    public function detail()
    {
        $id = $this->request->get('id');
        $res =  \app\common\model\VipPackage::where('id', $id)->find();
        return show(config('status.success'),'详情',$res);
    }


    


}