<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\user;

use app\adminapi\{lists\user\SelectUserLists,
    lists\user\UserFansLists,
    lists\user\UserInviterLists,
    logic\user\UserLogic,
    validate\user\UserValidate,
    validate\user\adjustUserWallet,
    controller\BaseAdminController};

/**
 * 用户控制器
 * Class UserController
 * @package app\adminapi\controller\user
 */
class User extends BaseAdminController
{

    /**
     * @notes 用户概况
     * @return \think\response\Json
     */
    public function index()
    {
        $data = (new UserLogic)->index();
        return $this->success('', $data);

    }


    /**
     * @notes 用户列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }


    /**
     * @notes 用户搜索条件列表
     */
    public function otherList()
    {
        return $this->success('', (new UserLogic())->otherLists());
    }


    /**
     * @notes 批量设置标签
     * @return \think\response\Json
     */
    public function setLabel()
    {
        $params = (new UserValidate())->post()->goCheck('setLabel');
        (new UserLogic)->setLabel($params);
        return $this->success('设置成功', [], 1, 1);
    }


    /**
     * @notes 用户详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail()
    {
        $params = (new UserValidate())->goCheck('detail');
        $detail = (new UserLogic)->detail($params['user_id']);
        // dd($detail);
        return $this->success('', $detail);

    }


    /**
     * @notes 设置用户信息
     * @return \think\response\Json
     */
    public function setInfo()
    {

        $params = (new UserValidate())->post()->goCheck('setInfo');
        (new UserLogic)->setUserInfo($params);
        return $this->success('更新成功', [], 1, 1);
    }

    /**
     * @notes 设置用户标签
     * @return \think\response\Json
     */
    public function setUserLabel()
    {
        $params = (new UserValidate())->post()->goCheck('setUserLabel');
        (new UserLogic)->setUserLabel($params);
        return $this->success('更新成功', [], 1, 1);
    }


    /**
     * @notes 调整用户钱包
     * @return \think\response\Json
     */
    public function adjustUserWallet()
    {
        $params = (new adjustUserWallet())->post()->goCheck();
        $res = (new UserLogic)->adjustUserWallet($params);
        if(true === $res){
            return $this->success('调整成功', [], 1, 1);
        }
        return $this->fail($res);
    }

    /**
     * @notes 粉丝列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getFans()
    {
        (new UserValidate())->goCheck('fans');
        return $this->dataLists(new UserFansLists());
    }

    /**
     * @notes 用户信息
     * @return \think\response\Json
     */
    public function info()
    {
        $params = (new UserValidate())->goCheck('info');
        $data = UserLogic::info($params);
        return $this->data($data);
    }

    /**
     * 删除用户
     */
    public function del()
    {
        $id = input('id');
        \think\facade\Db::startTrans();
        try{
            // 删除文件
            \app\common\model\Article::where('user_id',$id)->delete();
            // 删除评论
            \app\common\model\ArticleComment::where('user_id',$id)->delete();
            // 其他待删除用户数据...自行根据需求删除

            // 删除用户
            // \app\common\model\User::useSoftDelete(false);//关闭软删除
            $res=\app\common\model\User::where('id',$id)->delete();

            \think\facade\Db::commit();
            
            return show(1,'删除成功');
        }catch(\think\Exception $e){
            \think\facade\Db::rollback();
            return show(0,$e->getMessage());
        }

    }

    /**
     * 新建用户
     */
    public function add()
    {
        $params = $this->request->post();

        $passwordSalt = generateRandomString();
        $params['salt'] = $passwordSalt;

        $params['password'] = create_password($params['password'], $passwordSalt);
        // dd($params['password']);
        $params['sn']=rand(100,99).time();
        $res=\app\common\model\User::create($params);
        
        return show(1,'添加成功');
    }

    /**
     * @notes 我邀请的人
     * @return \think\response\Json
     */
    public function userInviterLists()
    {
        $params = (new UserValidate())->goCheck('userInviterLists');
        return $this->dataLists(new UserInviterLists());
    }

    /**
     * @notes 上级分销商调整信息
     * @return \think\response\Json
     */
    public function adjustFirstLeaderInfo()
    {
        $params = (new UserValidate())->goCheck('adjustFirstLeaderInfo');
        $result = UserLogic::adjustFirstLeaderInfo($params);
        return $this->data($result);
    }

    /**
     * @notes 选择用户列表
     * @return \think\response\Json
     */
    public function selectUserLists()
    {
        return $this->dataLists(new SelectUserLists());
    }

    /**
     * @notes 调整上级分销商
     * @return \think\response\Json
     */
    public function adjustFirstLeader()
    {
        $params = (new UserValidate())->post()->goCheck('adjustFirstLeader');
        $result = UserLogic::adjustFirstLeader($params);
        if ($result) {
            return $this->success('调整成功', [], 1, 1);
        }
        return $this->fail(UserLogic::getError());
    }

    public function delUser(){

        $params = (new UserValidate())->post()->goCheck('delUser');
        $result = (new UserLogic)->delUser($params);

        if ($result) {
            return $this->success('删除成功', [], 1, 1);
        }
        return $this->fail(UserLogic::getError());
    }

    public function changePassword()
    {
        $params = $this->request->post();

        try {

            $user = \app\common\model\User::find($params['user_id']);
            if (!$user) {
               return \show(0,'没有找到用户');
            }
            
            $passwordSalt = generateRandomString();
            $user->salt = $passwordSalt;

            $newPassword = create_password($params['password'], $passwordSalt);
            $user->password = $newPassword;
            $user->save();

            return \show(1,'修改成功');

        } catch (\Exception $e) {
            self::setError($e->getMessage());
            return \show(1,'修改失败');
        }
    }



}