<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect;

use app\adminapi\controller\BaseAdminController;

/**
 * 商家用户数据采集
 * Class UserController
 * @package app\adminapi\controller\user
 */
class MerchantGoodsCollect extends BaseAdminController
{
    // DZ-西瓜/分类行业数据采集
    public function insertDZXG()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');

        $saveData=[];

        $err=[];

        foreach($list as $v){
            // 查询商家
            $merchant=\app\common\model\Merchant::where("id",$v['shid'])->find();
            if(!$merchant){
                $err[]=[
                    "msg"=>"本地没有找到商家，请先采集商家",
                    "dz_uid"=>$v['uid'],
                ];
                continue;
            }
            $saveData[]=[
                "name"=>$v['title'],
                "desc"=>$v['jieshao'],
                "image"=>$v['icon'],
                "price"=>$v['disprice'],
                "stock"=>$v['stock'],
                "limit_per_user"=>0,
                "create_time"=>$v['crts'],
                "status"=>0,
            ];
        }

        try{
            $res = \think\facade\Db::name('merchant_goods')
            ->extra('IGNORE')
            ->insertAll($saveData);

            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('MerchantGoodsCollect','dz_page',$page);

            return \show(1,'导入成功',$err);
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }
    }

    // 查询上一次采集到第几页
    public function dzPageRecord()
    {
        $page=\app\common\service\ConfigService::get('MerchantGoodsCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

    public function dzPageRecordDel()
    {
        $page=\app\common\service\ConfigService::set('MerchantGoodsCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

}