<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\chat;

use app\adminapi\controller\BaseAdminController;
use \think\facade\Db;

/**
 * 群管理
 */
class Group extends BaseAdminController
{

    /**
     * 群列表
     */
    public function list()
    { 
        // 前端自定义多条件查询
        $params = $this->request->post();
        $where = [];
        
        if(isset($params['where'])){
            $where = $params['where'];
        }
    
       $list = \app\common\model\ChatGroup::paginate(10);
       return show(config('status.success'),'群列表',$list);

    }

    /**
     * 群详情
     */
    public function details($id)
    {
        $data = \app\common\model\ChatGroup::with([])->find($id);
        $data['memeber'] = \app\common\model\ChatGroupMember::with(['user'])
        ->where('group_id',$id)
        ->select();

        return show(config('status.success'),'群详情',$data);
    }

    /**
     * 群禁用
     */
    public function disable($id)
    {
        \app\common\model\ChatGroup::update([
            'status'=>0,
        ],['id'=>$id]);
        return show(config('status.success'),'设置成功');
    }

    /**
     * 群启用
     */
    public function enable($id)
    {
        \app\common\model\ChatGroup::update([
            'status'=>1,
        ],['id'=>$id]);
        return show(config('status.success'),'设置成功');
    }

    /**
     * 群解散
     */
    public function del($id)
    {
        Db::startTrans();
        try{

            // 删除群
            \app\common\model\ChatGroup::where('id',$id)
            ->delete();

            // 删除群成员
            \app\common\model\ChatGroupMember::where('group_id',$id)
            ->delete();

            Db::commit();

            return show(config('status.success'),'删除成功');
        }catch(\Exception $e){
            Db::rollback();
            return show(config('status.success'),$e->getMessage());
        }
    }

     /**
      * 群聊天记录
      */
    public function chat($id)
    {
        $list = \app\common\model\ChatGroupMessage::with(['fromUser','redPackets'])
        ->order('create_time','desc')
        ->paginate(10);

        return show(config('status.success'),'ok',$list);
    }


    /**
     * 修改
     * @return void
     */
    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\ChatGroup::where('id',$params['id'])->update($params);
        if(!$res){
            return show(0,'修改失败');
        };
        return show(1,'修改成功');
    }

}