<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\adminapi\controller\ad;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\ad\PositionLists;
use app\adminapi\logic\ad\PositionLogic;
use app\adminapi\validate\ad\PositionValidate;
use app\common\service\JsonService;

/**
 * 广告位
 */
class Position extends BaseAdminController
{
    /**
     * @notes 添加广告
     */
    public function add()
    {
        $params = (new PositionValidate())->post()->goCheck('add');
        $result = PositionLogic::add($params);
        if ($result) {
            return JsonService::success('添加成功');
        }
        return JsonService::fail(PositionLogic::getError());
    }



    /**
     * @notes 编辑广告
     */
    public function edit()
    {
        $params = (new PositionValidate())->post()->goCheck('edit');
        $result = PositionLogic::edit($params);
        if ($result) {
            return JsonService::success('编辑成功');
        }
        return JsonService::fail(PositionLogic::getError());
    }


    /**
     * @notes 删除广告
     */
    public function delete()
    {
        $params = (new PositionValidate())->post()->goCheck('del');
        $result = PositionLogic::delete($params);
        if ($result) {
            return JsonService::success('删除成功');
        }
        return JsonService::fail(PositionLogic::getError());
    }

    /**
     * @notes 详情
     */
    public function detail()
    {
        $params = $this->request->get();
        $detail = PositionLogic::detail($params);
        
        return $this->data($detail);
        
        
    }

    /**
     * @notes 广告位列表
     */
    public function lists()
    {
        return JsonService::dataLists(new PositionLists());
    }
}
