<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;
use app\common\model\UpdateRecord;
use think\facade\Db;
use think\exception\PDOException;

/**
 * 版本
 */
class Version extends BaseAdminController
{

    
    /*
    * 文件下载方法
    * $url 文件下载地址
    * $dir 存储的文件夹
    * $filename 文件名字
    */
    public function download_file($url, $dir, $filename = '') {
        if (empty($url)) {
            return false;
        }
        $ext = strrchr($url, '.');
 
        $dir = realpath($dir);
        //目录+文件
        $filename = (empty($filename) ? '/' . time() . '' . $ext : '/' . $filename);
        $filename = $dir . $filename;
        //开始捕捉
        ob_start();
 
        try {
            readfile($url);
        } catch (\Exception $e) {
            return json(["msg" => "文件下载失败，请联系开发人员！", 'code' => 100]);
        }
 
        $img = ob_get_contents();
        ob_end_clean();
        $size = strlen($img);
        $fp2 = fopen($filename, "a");
        fwrite($fp2, $img);
        fclose($fp2);
        return $filename;
    }
    
    /**
     * 检测框架本吧
     * Summary of index
     * @return \think\response\Json
     */
    public function index()
    {
        $data = [
            'system_version'=>\app\common\service\ConfigService::get('system','version',1.0),
            'php_version'=>\think\facade\App::version(),
            'think_version'=>\think\facade\App::version(),
        ];
       
        return show(config('status.success'),'version',$data);
    }


    /**
     * 远程服务器的最新版本
     */
    public function getRemoteVersion()
    {
        $api = AUTH_API.'/api/auth/version?domain='.$_SERVER['HTTP_HOST'];
        $res = file_get_contents($api);
        $data = json_decode($res,true);

        return show(config('status.success'),'',$data);
    }

    /**
     * 更新框架
     * @return void
     */
    public function upper_version()
    {
        try{
            // 获取本系统当前版本
            $system_version = \app\common\service\ConfigService::get('system','version',1);
            
            $api = AUTH_API.'/api/auth/version?domain='.$_SERVER['HTTP_HOST'];
            // 检查当前版本是否为最新版
            $res = file_get_contents($api);
            $data = json_decode($res,true);

            if($data['code']!=1){
                return show(config('status.error'),'没有最新的版本');
            }
            $data = $data['data'];

            if($system_version >= $data['version']){
                return show(config('status.error'),'当前为最新版本，不需要再更新');
            }

            // 先备份当前版本数据库和文件，用于回退恢复

            // ====================文件更新模块=====================
            // 下载远程更新包（需服务器支持）
            $savePath = '../runtime/update.zip';
            $res = file_put_contents($savePath, file_get_contents($data['download_url']));
            // 解压并覆盖文件（需安装 ZipArchive 扩展）
            $zip = new \ZipArchive;
            if ($zip->open($savePath) === true) {
                $zip->extractTo('../');
                $zip->close();
                unlink($savePath); // 删除临时文件
            }

            // ====================数据库更新模块=====================
            if($data['sql_download_url']!=''){
                $res = $this->updateSql($data['sql_download_url']);
                // if(!$res){
                //     return show(config('status.error'),$res);
                // }
            }
            

            UpdateRecord::create([
                'title' => $data['title'],
                'version' => $data['version'],
                'desc' => $data['desc'],
            ]);

            // 更新后修改当前数据库的历史版本
            \app\common\service\ConfigService::set('system','version',$data['version']);

            return show(config('status.success'),'更新成功');
        }catch(\Exception $e){
            return show(config('status.error'),$e->getMessage());
        }

    }

    /**
     * 更新数据库
     */
    public function updateSql($sql_download_url)
    {

        $sqlSavePath = '../runtime/update.sql';
        $res_sql = file_put_contents($sqlSavePath, file_get_contents($sql_download_url));
        if(!file_exists($sqlSavePath)){
            return false;
        }

        $sql = file_get_contents($sqlSavePath);
        $config = \think\facade\Config::get('database')['connections']['mysql'];

        $pdo = new \PDO("mysql:host={$config['hostname']};port={$config['hostport']};dbname={$config['database']}", $config['username'], $config['password']);
        // dd($pdo);
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

        $res = $pdo->exec($sql);
        if(!$res){
            return $res;
        }
        
        // 删除sql安装文件
        unlink($sqlSavePath);
        return true;

    }

    public function updateRecords()
    {
        return show(1,'更新记录',UpdateRecord::paginate());
    }

}


