<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

class AppBottomMenu extends BaseAdminController
{

    public function list()
    {
        $params = $this->request->get();

        $list = \app\common\model\AppBottomMenu::order('sort','desc')
        ->select()
        ->toArray();

        return show(config('status.error'),'',$list);
        
    }
    
    public function create()
    {
        $params = $this->request->post();
        $res = \app\common\model\AppBottomMenu::create($params);
        if(!$res){
            return show(config('status.error'),'添加失败');
        }
        return show(config('status.success'),'添加成功');
    }

    public function del($id)
    {
        $res = \app\common\model\AppBottomMenu::where('id',$id)->delete();
        if(!$res){
            return show(config('status.error'),'删除失败');
        }
        return show(config('status.success'),'删除成功');
    }

    public function details($id)
    {
        $res = \app\common\model\AppBottomMenu::where('id',$id)->find();
        if(!$res){
            return show(config('status.error'),'查询失败');
        }
        return show(config('status.success'),'查询成功',$res);
    }

    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\AppBottomMenu::update($params,['id'=>$params['id']]);
        if(!$res){
            return show(config('status.error'),'修改失败');
        }
        return show(config('status.success'),'修改成功');
    }

}