<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

 return [
    // 模板基础信息
    'basic' => [
        'description' => '适用于博客系统的后台表单渲染模板，支持图片上传、各类输入框等组件，表单提交至当前页面',
        'author' => '自定义作者',
        'update_time' => '2025-12-13',
		'name' => '博客风格',
		'version' => '1.3005'
    ],

    // 前端渲染配置（核心）
    'frontend' => [

        // 表单字段配置（保持原有组件，仅适配自提交逻辑）
        'fields' => [
            // 示例1：文本输入框（博客标题）
            'title' => [
                'type' => 'input', // 组件类型
                'sub_type' => 'text', // 输入类型：text/number/email等
                'label' => '博客标题', // 字段标签
                'placeholder' => '请输入博客标题', // 占位提示
                'default_value' => '', // 默认值（自提交时可回填提交的数据）
                'rules' => [ // 校验规则
                    'required' => true, // 是否必填
                    'message' => '博客标题不能为空', // 校验提示
                    'max_length' => 100, // 最大长度
                    'max_message' => '标题长度不能超过100个字符',
                ],
                'props' => [ // 额外属性（透传至前端组件）
                    'size' => 'medium', // 尺寸：small/medium/large
                    'disabled' => false, // 是否禁用
                    'clearable' => true, // 是否显示清除按钮
                ],
                'col' => [ // 栅格布局（适配ElementUI等框架）
                    'span' => 24, // 占用列数
                    'offset' => 0, // 偏移列数
                ],
                'tip' => '建议标题简洁明了，突出核心内容', // 字段说明提示

                'value'=>'',//设置的值
            ],

            // 示例2：图片上传组件（博客封面）
            'cover' => [
                'type' => 'upload', // 组件类型
                'sub_type' => 'image', // 上传类型：image/file/video
                'label' => '博客封面',
                'placeholder' => '',
                'default_value' => '', // 自提交后可回填已上传的图片地址
                'rules' => [
                    'required' => true,
                    'message' => '请上传博客封面',
                    'file_type' => ['jpg', 'png', 'webp'], // 允许的文件类型
                    'file_type_message' => '仅支持jpg、png、webp格式图片',
                    'max_size' => 2, // 最大文件大小（MB）
                    'max_size_message' => '图片大小不能超过2MB',
                ],
                'props' => [
                    'action' => '', // 图片上传也指向当前页面（自处理上传）
                    'headers' => [ // 请求头（如token）
                        'Authorization' => 'Bearer {token}',
                    ],
                    'multiple' => false, // 是否允许多图上传
                    'show_upload_list' => true, // 是否显示上传列表
                    'list_type' => 'picture-card', // 列表展示方式
                    'limit' => 1, // 最大上传数量
                    'upload_identifier' => 'blog_cover_upload', // 上传请求标识
                ],
                'col' => [
                    'span' => 24,
                ],
                'tip' => '建议尺寸：1200x600px，图片大小不超过2MB',
                
                'value'=>'',//设置的值
            ],

            // 示例3：富文本编辑器（博客内容）
            'content' => [
                'type' => 'editor', // 富文本编辑器
                'label' => '博客内容',
                'placeholder' => '请输入博客正文内容',
                'default_value' => '', // 自提交后回填内容
                'rules' => [
                    'required' => true,
                    'message' => '博客内容不能为空',
                ],
                'props' => [
                    'height' => 500, // 编辑器高度
                    'menus' => [ // 编辑器功能菜单
                        'head', 'bold', 'italic', 'underline', 'strike', 'list',
                        'justify', 'link', 'image', 'table', 'code', 'undo', 'redo'
                    ],
                    'upload_img_action' => '', // 编辑器内图片上传也指向当前页面
                    'editor_upload_identifier' => 'blog_editor_upload', // 编辑器上传标识
                ],
                'col' => [
                    'span' => 24,
                ],
                'tip' => '支持图片、表格、代码块等格式，请勿发布违规内容',

                'value'=>'',//设置的值
            ],

            // 示例4：下拉选择框（博客分类）
            'category_id' => [
                'type' => 'select', // 下拉选择
                'label' => '博客分类',
                'placeholder' => '请选择博客分类',
                'default_value' => '', // 自提交后回填选中值
                'rules' => [
                    'required' => true,
                    'message' => '请选择博客分类',
                ],
                'props' => [
                    'multiple' => false, // 是否多选
                    'clearable' => true, // 是否可清除
                    'filterable' => true, // 是否可搜索
                    'remote' => true, // 是否远程加载选项
                    'remote_url' => '', // 分类列表也从当前页面获取
                    'remote_method' => 'GET', // 请求方式
                    'remote_identifier' => 'blog_category_list', // 远程请求标识
                ],
                // 本地选项（remote为false时生效）
                'options' => [
                    ['label' => '技术博客', 'value' => 1],
                    ['label' => '生活随笔', 'value' => 2],
                ],
                'col' => [
                    'span' => 12,
                ],
                'tip' => '选择对应的分类，便于用户检索',

                'value'=>'',//设置的值
            ],

            // 示例5：开关组件（是否发布）
            'is_publish' => [
                'type' => 'switch', // 开关
                'label' => '是否发布',
                'default_value' => 1, // 默认发布，自提交后回填状态
                'rules' => [],
                'props' => [
                    'active_value' => 1, // 开启值
                    'inactive_value' => 0, // 关闭值
                    'active_text' => '发布', // 开启文字
                    'inactive_text' => '草稿', // 关闭文字
                ],
                'col' => [
                    'span' => 12,
                ],
                'tip' => '开启后博客将对外展示，关闭则仅保存为草稿',
                
                'value'=>'',//设置的值
            ],

            // 隐藏字段：标识表单提交（辅助后端判断）
            'form_identifier' => [
                'type' => 'hidden', // 隐藏输入框
                'default_value' => 'blog_form', // 固定标识值
                'props' => [
                    'name' => 'form_identifier', // 表单字段名
                ],

                'value'=>'',//设置的值
            ],
        ],

    ],

];
