<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;
use app\common\service\ConfigService;
use app\api\logic\ConfigLogic;

use EasyWeChat\OfficialAccount\Application;
use app\common\service\wechat\WeChatConfigService;

/**
 * 配置控制器
 * Class ConfigController
 * @package app\api\controller
 */
class Config extends BaseShopController
{
    public array $notNeedLogin = ['getconfig', 'getPolicyAgreement','getInviteConfig','getUpgrade','getWechatShareConfig'];

    /**
     * @notes 获取系统配置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $data = (new ConfigLogic())->getConfig();

        $oss_domain = [];
        // 阿里云存储
        $aliyun = ConfigService::get('storage', 'aliyun');
        if(isset($aliyun['domain'])){
            $oss_domain['aliyun'] = $aliyun['domain'];
        }
         // 阿里云存储
         $qcloud = ConfigService::get('storage', 'qcloud');
         if(isset($qcloud['domain'])){
             $oss_domain['qcloud'] = $qcloud['domain'];
         }
         // 七牛云存储
         $qiniu = ConfigService::get('storage', 'qiniu');
         if(isset($qiniu['domain'])){
             $oss_domain['qiniu'] = $qiniu['domain'];
         }
         
         $terminal = $this->request->header('terminal');
         if($terminal==5){
            // 苹果app
            $data['app_version'] = \app\common\model\DevUpgrade::where('terminal',2)
            ->order('version','desc')
            ->find();
         }elseif($terminal==6){
            // 安卓app
            $data['app_version'] = \app\common\model\DevUpgrade::where('terminal',1)
            ->order('version','desc')
            ->find();
         }

         $data['oss_domain']=$oss_domain;

        return $this->success('',$data);
    }

    /**
     * @notes 获取政策协议
     * @return \think\response\Json
     */
    public function getPolicyAgreement()
    {
        $result =  (new ConfigLogic())->getPolicyAgreement();
        return $this->data(['content' => $result]);
    }


     /**
     * @notes 获取邀请好友配置
     * @return \think\response\Json
     */
    public function getInviteConfig()
    {
        $result =  (new ConfigLogic())->getInviteConfig();
        return $this->data(['content' => $result]);
    }


    /**
     * @notes 获取更新
     * @return \think\response\Json
     */
    public function getUpgrade()
    {
        $version  = $this->request->header('version');
        $terminal = $this->request->get('terminal');
        
        $data = (new ConfigLogic())->getUpgrade($version,$terminal);
        return $this->success('',$data); 
    }


    /**
     * @throws InvalidArgumentException
     */
    public function getWechatShareConfig()
    {
        return[show(1,'',(new Application(WeChatConfigService::getOpConfig()))->getUtils($params=$this->request->param())->buildJsSdkConfig($params['url']??'',isset($params['jsApiList'])?explode(',',$params['jsApiList']):[],isset($params['openTagList'])?explode(',',$params['openTagList']):[],$params['debug']??false))][0];
    }
}