<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;
use think\facade\Db;
use app\common\service\map\TencentService;

/**
 * 地区
 */
class Region extends BaseShopController
{

    public array $notNeedLogin = ['list'];

    public function search() {
        $params = $this->request->param();

        if (!isset($params['keyword']) || !isset($params['boundary'])) {
            return show(0,'参数错误');
        }

        $result = TencentService::search($params['keyword'], $params['boundary'], $params['page_size'] ?? 15, $params['page_index'] ?? 1);
        if (!$result) {
            return show(0,'查询失败', $result);
        }
        return show(1,'成功',$result);
    }
    
    public function geocoder() {
        $params = $this->request->param();
        
        if (!isset($params['latitude']) || !isset($params['longitude'])) {
            return show(0,'参数错误');
        }
        
        $result = TencentService::geocoder($params['latitude'], $params['longitude']);
        if (!$result) {
            return show(0,'查询失败');
        }
        return show(1,'成功',$result);
    }
    
    /**
     * 地区接口
     * @return \think\response\Json
     */
    public function list()
    {
        
        $params = $this->request->get();

        $where = [];
        
        $order = [];

        if(isset($params['pid'])){
            $where[]=[
                'parent_id','=',$params['pid'],
            ];
        }

        // 按id查询
        if(isset($params['ids'])){
            $ids_arr = explode(',',$params['ids']);
            $where[]=[
                'id','in',$params['ids'],
            ];
            $order['level']='asc';
        }
        
        $list = \app\common\model\Region::where($where)
        ->order($order)
        ->select()
        ->toArray();
        
        if(isset($params['parent_id']) && $params['parent_id']==0){
            $list = linear_to_tree($list,'sub','id','parent_id');
        }

        return show(config('status.success'),'',$list);
        
    }

}
