<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists;

use app\common\lists\ListsExcelInterface;
use app\common\lists\ListsSearchInterface;
use app\common\model\Article;


class ArticleLists extends BaseAdminDataLists implements ListsSearchInterface, ListsExcelInterface
{
    /**
     * @notes 设置导出字段
     * @return string[]
     */
    public function setExcelFields(): array
    {
        return [
            'title' => '标题',
            
            'is_show_desc' => '文章状态',
            'visit' => '浏览量',
            'sort' => '排序',
            'create_time' => '创建时间',
        ];
    }

    /**
     * @notes 设置默认表名
     * @return string
     */
    public function setFileName(): string
    {
        return '帖子列表';
    }

    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch(): array
    {
        return [
   
            '%like%' => ['title'],
            'between_time' => 'a.create_time'
        ];
    }

    /**
     * @notes 自定义搜索
     */
    public function queryWhere()
    {
        // 用户搜索
        if(isset($this->params['keyword'])  && $this->params['keyword']) {
            $this->searchWhere[] = ['nickname|sn|mobile', '=', $this->params['keyword']];
        }

        // 状态搜索
        if(isset($this->params['status'])) {
            $this->searchWhere[] = ['status', '=', $this->params['status']];
        }


    }


    /**
     * @notes 文章/帮助列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {

        
        $this->queryWhere();
        $this->params['title'] = isset($this->params['title'])?$this->params['title']:'';

        $lists = Article::alias('a')
            ->leftJoin('user u','a.user_id = u.id')
            ->field('a.id,a.user_id,title,image,is_top,is_recomment,region,a.status,a.status as status_desc,a.visit,a.sort,a.create_time,nickname,sn,content,examine_result,examine_id,examine_label,examine_msg')
            ->where($this->searchWhere);
        

        if(isset($this->params['title']) && $this->params['title']){
            $lists = $lists->whereOr('content','like','%'.$this->params['title'].'%');
            $lists = $lists->whereOr('title','like','%'.$this->params['title'].'%');
        }

        $lists =   $lists->order('a.sort desc,a.id desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->append(['comment_num' ,'collect_num'])
            ->select()
            ->toArray();
        
        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        $this->queryWhere();
        return Article::alias('a')->join('user u','a.user_id = u.id')->where($this->searchWhere)->count();
    }
}