<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\logic\settings\user;
use app\common\{
    enum\UserEnum,
    service\ConfigService,
    service\FileService};
/**
 * 设置-用户设置逻辑层
 * Class UserLogic
 * @package app\adminapi\logic\config
 */
class UserLogic
{


    /**
     * @notes 获取用户设置
     * @return array
     */
    public static function getConfig():array
    {

     
        $config = [
            //默认头像
            'default_avatar'            => ConfigService::get('config', 'default_avatar',  FileService::getFileUrl(config('project.default_image.user_avatar'))),
            'default_user_home_bj'      => ConfigService::get('config', 'default_user_home_bj' ,FileService::getFileUrl(config('project.default_image.user_home_bj')))
        ];
        return $config;
    }

    /**
     * @notes 设置用户设置
     * @param array $postData
     * @return bool
     */
    public function setConfig(array $params):bool
    {
        ConfigService::set('config', 'default_avatar', $params['default_avatar']);

        ConfigService::set('config', 'default_user_home_bj', $params['default_user_home_bj']);
        return true;
    }

    public function getRegisterConfig():array
    {

        $config = [
            //注册方式
            'register_way'              => ConfigService::get('config', 'register_way', config('project.login.register_way')),
            //登录方式
            'login_way'                 => ConfigService::get('config', 'login_way',  config('project.login.login_way')),
            //手机号码注册需验证码
            'is_mobile_register_code'   => ConfigService::get('config', 'is_mobile_register_code',  config('project.login.is_mobile_register_code')),
            //注册强制绑定手机
            'coerce_mobile'             => ConfigService::get('config', 'coerce_mobile',  config('project.login.coerce_mobile')),
            //APP微信授权登录
            'app_wechat_auth'           => ConfigService::get('config', 'app_wechat_auth',  config('project.login.app_wechat_auth')),
            //微信默认登录方式
            'wechat_default_login_way' => ConfigService::get('config', 'wechat_default_login_way',  config('project.login.wechat_default_login_way')),
            //H5默认登录方式
            'h5_default_login_way'      => ConfigService::get('config', 'h5_default_login_way',  config('project.login.h5_default_login_way')),
            //APP默认登录方式
            'app_default_login_way'    => ConfigService::get('config', 'app_default_login_way',  config('project.login.app_default_login_way')),

            "sms_limit"=>[
                "sms_send_day_limit_status"=>ConfigService::get('config', 'sms_send_day_limit_status',0),//是否开启手机号每日发送限制
                "sms_send_day_limit_num"=>ConfigService::get('config', 'sms_send_day_limit_num', 0),//每日发送总数量

                // 同一ip发送限制
                "ip"=>[
                    "send_count_limit_status"=>ConfigService::get('sms_ip_limit', 'send_count_limit_status',0),//是否开启同一ip发送总数限制
                    "hour_send_num"=>ConfigService::get('sms_ip_limit', 'hour_send_num', 0),//同一ip每小时发送条数
                    "day_send_num"=>ConfigService::get('sms_ip_limit', 'day_send_num', 0),//同一ip每天发送条数
                    "send_err"=>ConfigService::get('sms_ip_limit', 'send_err', "短信发送太频繁了，请稍后再试，如有疑问请联系平台管理员"),//同一ip超出发送限制提示语
                ],

                "mobile"=>[
                    "send_count_limit_status"=>ConfigService::get('sms_mobile_limit', 'send_count_limit_status',0),//是否开启同一ip发送总数限制
                    "hour_send_num"=>ConfigService::get('sms_mobile_limit', 'hour_send_num', 0),//同一ip每小时发送条数
                    "day_send_num"=>ConfigService::get('sms_mobile_limit', 'day_send_num', 0),//同一ip每天发送条数
                    "send_err"=>ConfigService::get('sms_mobile_limit', 'send_err', "短信发送太频繁了，请稍后再试，如有疑问请联系平台管理员"),//同一ip超出发送限制提示语
                ]
            ]
            
        ];
        return $config;
    }


    /**
     * @notes 设置登录注册
     * @param array $params
     * @return bool
     */
    public static function setRegisterConfig(array $params):bool
    {
        //注册方式:1-手机号注册
        ConfigService::set('config', 'register_way', $params['register_way']);
        //登录方式：1-账号密码登录；2-手机短信验证码登录
        ConfigService::set('config', 'login_way', $params['login_way']);
        //手机号码注册需验证码
        ConfigService::set('config', 'is_mobile_register_code', $params['is_mobile_register_code']);
        //注册强制绑定手机
        ConfigService::set('config', 'coerce_mobile', $params['coerce_mobile']);
        //APP微信授权登录
        ConfigService::set('config', 'app_wechat_auth', $params['app_wechat_auth']);
        //微信默认登录方式
        ConfigService::set('config', 'wechat_default_login_way', $params['wechat_default_login_way']);
        //H5默认登录方式
        ConfigService::set('config', 'h5_default_login_way', $params['h5_default_login_way']);
        //APP默认登录方式
        ConfigService::set('config', 'app_default_login_way', $params['app_default_login_way']);

        // 短信发送量限制
        ConfigService::set('config', 'sms_send_day_limit_status', $params["sms_limit"]['sms_send_day_limit_status']);//是否开启手机号每日发送限制
        ConfigService::set('config', 'sms_send_day_limit_num', $params["sms_limit"]['sms_send_day_limit_num']);//每日发送总数量
        
        // 同一手机号发送限制-------------------------
        ConfigService::set('sms_mobile_limit', 'send_count_limit_status', $params["sms_limit"]['mobile']['send_count_limit_status']);//是否开启同一手机号发送总数限制
        ConfigService::set('sms_mobile_limit', 'hour_send_num', $params["sms_limit"]['mobile']['hour_send_num']);//同一手机号每小时发送条数
        ConfigService::set('sms_mobile_limit', 'day_send_num', $params["sms_limit"]['mobile']['day_send_num']);//同一手机号每天发送条数
        ConfigService::set('sms_mobile_limit', 'send_err', $params["sms_limit"]['mobile']['send_err']);//同一手机号超出发送限制提升语

        // 同一ip发送限制
        ConfigService::set('sms_ip_limit', 'send_count_limit_status', $params["sms_limit"]['ip']['send_count_limit_status']);//是否开启同一ip发送总数限制
        ConfigService::set('sms_ip_limit', 'hour_send_num', $params["sms_limit"]['ip']['hour_send_num']);//同一ip每小时发送条数
        ConfigService::set('sms_ip_limit', 'day_send_num', $params["sms_limit"]['ip']['day_send_num']);//同一ip每天发送条数
        ConfigService::set('sms_ip_limit', 'send_err', $params["sms_limit"]['ip']['send_err']);//同一ip超出发送限制提升语
        
        return true;

    }


    /**
     * @notes 判断用户是否具有邀请下级资格
     * @param $userId
     * @return bool|mixed
     */
    public static function eligible($userId)
    {
        // 邀请下级资格
        $inviteWays = ConfigService::get('config', 'invite_ways', config('project.default_user.invite_ways'));
        // 全部用户可邀请
        if($inviteWays == UserEnum::INVITE_WAYS_ALL) {
            return true;
        }

        return false;
    }


    /**
     * @notes 
     */
    public static function getInviteConfig():array
    {
        
        $invite_friend_gift_money = ConfigService::get('config', 'invite_friend_gift_money', 0);
        
        $invite_gift_money = ConfigService::get('config', 'invite_gift_money', 0);

        return [
            'invite_gift_money' => $invite_gift_money,
            'invite_friend_gift_money' => $invite_friend_gift_money
        ];
  

    }


    /**
     * @notes 
     * @param array $params
     * @return bool
     */
    public static function setInviteConfig(array $params):bool
    {
       
        ConfigService::set('config', 'invite_friend_gift_money', $params['invite_friend_gift_money']);
        
        ConfigService::set('config', 'invite_gift_money', $params['invite_gift_money']);
        return true;

    }

}