<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings;

use app\adminapi\controller\BaseAdminController;

use app\common\service\ConfigService;

/**
 * APP设置控制器
 * Class WebAppSettingController
 * @package app\adminapi\controller\settings\app
 */
class SeoSetting extends BaseAdminController
{

    /**
     * @notes 获取App设置
     * @return \think\response\Json
    */
    public function getConfig()
    {
        return show(1,'',[
            'index_title'=> ConfigService::get('seo', 'index_title', ''),
            'index_keywords'=>ConfigService::get('seo', 'index_keywords', ''),
            'index_description'=>ConfigService::get('seo', 'index_description', ''),
            
            'article_list_title'=> ConfigService::get('seo', 'article_list_title', ''),
            'article_list_keywords'=>ConfigService::get('seo', 'article_list_keywords', ''),
            'article_list_description'=>ConfigService::get('seo', 'article_list_description', ''),
            
            'article_details_title'=> ConfigService::get('seo', 'article_details_title', ''),
            'article_details_keywords'=>ConfigService::get('seo', 'article_details_keywords', ''),
            'article_details_description'=>ConfigService::get('seo', 'article_details_description', ''),
        ]);
    }

    /**
     * @notes App设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        
        // 首页
        ConfigService::set('seo', 'index_title', $params['index_title'] ?? '');
        ConfigService::set('seo', 'index_keywords', $params['index_keywords'] ?? '');
        ConfigService::set('seo', 'index_description', $params['index_description'] ?? '');

        // 帖子列表
        ConfigService::set('seo', 'article_list_title', $params['article_list_title'] ?? '');
        ConfigService::set('seo', 'article_list_keywords', $params['article_list_keywords'] ?? '');
        ConfigService::set('seo', 'article_list_description', $params['article_list_description'] ?? '');

        // 帖子内容
        ConfigService::set('seo', 'article_details_title', $params['article_details_title'] ?? '');
        ConfigService::set('seo', 'article_details_keywords', $params['article_details_keywords'] ?? '');
        ConfigService::set('seo', 'article_details_description', $params['article_details_description'] ?? '');

        return $this->success('设置成功', [], 1, 1);
    }

}