<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;

// 网页模板相关
class Template extends BaseShopController
{

    public array $notNeedLogin = ['getCurrentTemplatePath','getConfig'];

    // 获取模板配置
    public function getConfig($type)
    {
        $config = require ROOT_DIR.'/template/use/'.$type.'/config.php';
        $data = [];

        foreach($config['frontend']['fields'] as $k=>$v){
            $data[$k]=$v['value'];
        }
        
        return show(1,'',$data);
    }

    
    // 获取当前模板访问路径
    public function getCurrentTemplatePath()
    {
        $baseUrl='/template/view/';
        $data=[
            'pc'=>$baseUrl.'pc/'.\app\common\service\ConfigService::get('web_template', 'pc',"default").'/html/index.html',
            'mobile'=>$baseUrl.'mobile/'.\app\common\service\ConfigService::get('web_template', 'mobile',"default").'/html/index.html',
        ];
        
        return \show(1,'模板访问路径',$data);
    }

}