<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\logic;

use app\common\model\DevUpgrade;
use app\common\service\{
    FileService,
    ConfigService,

};

/**
 * 配置逻辑层
 * Class CollectLogic
 * @package app\common\logic
 */
class ConfigLogic
{
    /**
     * @notes 获取系统配置
     * @return array
     */
    public function getConfig():array
    {
        $wechatLoginBackUrl = 'https://'.$_SERVER['HTTP_HOST']."/api/login/wechatQrLoginCallback";
        $state = rand(1000,999);

        $config = [
            //注册方式
            'register_way'              => ConfigService::get('config', 'register_way',  config('project.login.register_way')),
            //登录方式
            'login_way'                 => ConfigService::get('config', 'login_way',config('project.login.login_way')),
            //微信默认登录方式
            'wechat_default_login_way' => ConfigService::get('config', 'wechat_default_login_way',  config('project.login.wechat_default_login_way')),
            //H5默认登录方式
            'h5_default_login_way'      => ConfigService::get('config', 'h5_default_login_way',  config('project.login.h5_default_login_way')),
            //APP默认登录方式
            'app_default_login_way'    => ConfigService::get('config', 'app_default_login_way',  config('project.login.app_default_login_way')),
            //手机号码注册需验证码
            'is_mobile_register_code'   => ConfigService::get('config', 'is_mobile_register_code',  config('project.login.is_mobile_register_code')),
            //注册强制绑定手机
            'coerce_mobile'             => ConfigService::get('config', 'coerce_mobile', config('project.login.coerce_mobile')),
            //oss域名
            // 'oss_domain'                => FileService::getFileUrl(),
            //logo
            'logo'                      => FileService::getFileUrl(ConfigService::get('shop', 'mobile_logo')),
            //分享页面
            'share_page'                => ConfigService::get('shop', 'share_page'),
            //分享标题
            'share_title'               => ConfigService::get('shop', 'share_title', ''),
            //分享简介
            'share_intro'               => ConfigService::get('shop', 'share_intro', ''),
            //分享图片
            'share_image'               => FileService::getFileUrl(ConfigService::get('shop', 'share_image')),
            // 小程序商城关闭状态
            'mnp_status'                => ConfigService::get('shop', 'status', 1),
            // H5商城关闭状态
            'h5_status'                 => ConfigService::get('h5', 'status', 1),
            // PC商城关闭状态
            'pc_status'                 => ConfigService::get('pc', 'status', 1),
            // pc默认文章背景图片
            'pc_article_default_image'  => FileService::getFileUrl(ConfigService::get('shop', 'pc_article_default_image', config('project.default_image.pc_article_detault_bj'))),
            // 版权信息
            'copyright'                 => ConfigService::get('shop', 'copyright', ''),
            // 备案号
            'record_number'             => ConfigService::get('shop', 'record_number', ''),
            // 备案链接地址
            'record_system_link'        => ConfigService::get('shop', 'record_system_link', ''),
            
            // ws地址域名
            'ws_domain'                 => env('project.ws_domain', 'ws:127.0.0.1'),
            //app协议弹出
            'pop_agreement'             => ConfigService::get('app','pop_agreement',1),
            // APP下载地址
            'ios_download_url'          => ConfigService::get('app', 'ios_download_url', ''),
            'android_download_url'      => ConfigService::get('app', 'android_download_url', ''),

            'area_js'                   => '/resource/js/area.js',
            'shop_name'                 => ConfigService::get('shop', 'name'),
            'user_home_bj'              => ConfigService::get('config', 'default_user_home_bj'),
            'invite_friend_gift_money'  => ConfigService::get('config', 'invite_friend_gift_money'),

            // file_type
            'topic_name'                 => ConfigService::get('topic','topic_name','话题'),

            'circle_name'                 => ConfigService::get('circle','circle_name','话题'),
            'plugin_open_style'           => ConfigService::get('circle','plugin_open_style',0),

            // 登录背景图
            'user_login_image'          => ConfigService::get('shop','user_login_image'),

            'template'=>[
                'mobile'=>[
                    'index'             => ConfigService::get('template','mobile_index','sns'),
                    'user'              => ConfigService::get('template','mobile_user','sns'),
                    'cate'              => ConfigService::get('template','mobile_cate','side'),
                ],
                'pc'=>[],
            ],

            'plugin_list'=>ActivePlugin(),
            
            // app底部菜单
            'app_bottom_menu' => \app\common\model\AppBottomMenu::where('status',1)->order('sort','desc')->select()->toArray(),

            // 文章设置
            'article'=>[
                'disclaimers_status'=>ConfigService::get('article','disclaimers',1),
                'disclaimers_value'=>ConfigService::get('article','disclaimers',''),
                'send_show_title' => ConfigService::get('article','send_show_title',1),
                'rand_image' => \app\common\model\ArticleRandImage::orderRaw('RAND()')->limit(10)->select()->toArray(),
                'enable_rich_text' => ConfigService::get('article','enable_rich_text',0),
                'max_word_len_ellipsis' => ConfigService::get('article', 'max_word_len_ellipsis', 0),
                'min_word_len_ellipsis' => ConfigService::get('article', 'min_word_len_ellipsis', 0),
            ],

            'chat'=>[
                'private_status'  => ConfigService::get('chat', 'private_status',0),
                'group_status'  => ConfigService::get('chat', 'group_status',0),
                'circle_status'  => ConfigService::get('chat', 'circle_status',0),
            ],

            // 小程序消息通知模板
            'notice_mp'=>[
                'notice_chat_template'       => [
                    'name'=>'长期订阅消息通知',
                    'id'=>ConfigService::get('mini_program', 'notice_chat_template_id', '')
                ],
                'notice_comment_template_id'       => [
                    'name'=>'作品被评论消息通知（一次性订阅）',
                    'id'=>ConfigService::get('mini_program', 'notice_comment_template_id', '')
                ],
            ],

            // 首页公告
            'index_notice'=> ConfigService::get('index','notice'),
            
            'share'=>\app\common\service\ConfigService::get('share'),

            'map'=>ConfigService::get('map', 'tencent_map_key',''),

            'level'=>\app\common\model\UserLevel::field('id,name,rank,image,background_image')->select()->toArray(),

            'video_status'=>ConfigService::get('article', 'video_status',0),
            
            'attachment_status'=>ConfigService::get('article', 'attachment_status',0),
            'netdisk_status'=>ConfigService::get('article', 'netdisk_status',0),
            'vote_status'=>ConfigService::get('article', 'vote_status',0),

            "send_get_integral"=>ConfigService::get('article', 'send_get_integral',0),
            "send_get_experience"=>ConfigService::get('article', 'send_get_experience',0),
            "send_get_experience_globle"=>ConfigService::get('article', 'send_get_experience_globle',0),

            "is_demo"=>ConfigService::get('config','is_demo'),

            'share_domain' => ConfigService::get('config','share_domain'),

            'send_require_wechat'=>ConfigService::get('article', 'send_require_wechat',0),

            
            'filing_number' => ConfigService::get('shop', 'filing_number',[]),
            'filing_system_link' => ConfigService::get('shop', 'filing_system_link',[]),

            // 网站应用
            "wx_webapp"=>[
                'app_id'=> ConfigService::get('webapp', 'app_id',''),
                'callback_url'=>$wechatLoginBackUrl
            ],

            // seo配置
            "seo"=>[
                'index_title'=> ConfigService::get('seo', 'index_title', ''),
                'index_keywords'=>ConfigService::get('seo', 'index_keywords', ''),
                'index_description'=>ConfigService::get('seo', 'index_description', ''),
                
                'article_list_title'=> ConfigService::get('seo', 'article_list_title', ''),
                'article_list_keywords'=>ConfigService::get('seo', 'article_list_keywords', ''),
                'article_list_description'=>ConfigService::get('seo', 'article_list_description', ''),
                
                'article_details_title'=> ConfigService::get('seo', 'article_details_title', ''),
                'article_details_keywords'=>ConfigService::get('seo', 'article_details_keywords', ''),
                'article_details_description'=>ConfigService::get('seo', 'article_details_description', ''),
            ]

        ];
        
        $config['wechat_web_qr_login_url']="https://open.weixin.qq.com/connect/qrconnect?appid=".ConfigService::get('webapp', 'app_id','')."&redirect_uri=".$wechatLoginBackUrl."&response_type=code&scope=snsapi_login&state=".$state."#wechat_redirect";
        
        return $config;
        
    }

    
    /**
     * @notes 获取政策协议
     * @return array|string
     */
    public function getPolicyAgreement()
    {
        $params = request()->get();
        // // 服务协议
        if (isset($params['type']) && $params['type'] == 1) {
            return ConfigService::get('shop', 'service_agreement_content', '');
        }
        // 隐私政策
        if (isset($params['type']) && $params['type'] == 2) {
            return ConfigService::get('shop', 'privacy_policy_content', '');
        }

        // 关于我们
        if (isset($params['type']) && $params['type'] == 3) {
            return ConfigService::get('shop', 'about_content', '');
        }

        return ConfigService::get('shop', $params['type'], '');
    }



    public function getInviteConfig()
    {
       
    }


    /**
     * 获取更新
     */
    public function getUpgrade($version,$terminal){

        $clients = [
            1 =>  'android',
            2 =>  'ios'
        ];
        $upgrade = DevUpgrade::where('terminal', 'in', [$terminal, 0]) // terminal等于客户端类型或者0（全部）
            ->order('version desc')
            ->find();
            
        if ($upgrade && $upgrade['version'] > $version) {
            // 有新版本需要更新
            if ($upgrade['force_update'] == 1) {
                // 强制更新
                $data['need_update'] = true;
                $data['force_update'] = true;
            } else {
                // 非强制更新
                $data['need_update'] = true;
                $data['force_update'] = false;
            }

            // $url_paths = json_decode($upgrade['url_paths'],true);

            $data['new_version']    = $upgrade['version'];
            $data['update_content'] = $upgrade['title'];
            $data['update_url']  =  ConfigService::get('app', $clients[$terminal].'_download_url', '');
            $data['is_silently'] = false;
            $data['platform'] = $clients[$terminal];
            

            // 返回给客户端更新信息
            return $data;
        } else {
            // 没有新版本需要更新
            return ['need_update' => false];
        }
    }


}