<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\lists\user;
use app\adminapi\lists\BaseAdminDataLists;
use app\common\lists\ListsExcelInterface;
use app\common\lists\ListsExtendInterface;
use app\common\model\User;

/**
 * 用户列表
 * Class UserLists
 * @package app\adminapi\lists\user
 */
class UserLists extends BaseAdminDataLists implements ListsExcelInterface
{

    /**
     * @notes 搜索参数
     * @return array
     */
    public function setSearch(): array
    {
        return  array_intersect(array_keys($this->params),['disable','keyword','level','label_id','min_amount','max_amount','source','create_start_time','create_end_time']);
    }


    /**
     * @notes 搜索列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $lists = User::withSearch($this->setSearch(), $this->params)
            ->with(['user_level'])
            ->limit($this->limitOffset, $this->limitLength)
            ->field('id,sn,account,nickname,avatar,mobile,level,user_integral,user_money+user_earnings as total_user_money,total_order_amount,login_time,create_time,disable,is_logoff,login_ip,login_time')
            ->order('id desc')
            ->withAttr('user_money',function ($value){
                return '¥'.$value;
            })
            ->withAttr('total_order_amount',function ($value){
                return '¥'.$value;
            })
            ->where('remark','!=','bot')
            ->select();

        // --- 校准后台列表等级开始 ---
        $levelList = \think\facade\Db::name('user_level')->order('rank asc')->select()->toArray();
        foreach ($lists as &$item) {
            $integral = (int)($item->user_integral ?? 0);
            $correctLevelData = $levelList[0] ?? null;
            if (!empty($levelList)) {
                foreach ($levelList as $lvl) {
                    if ($integral >= (int)$lvl['experience']) {
                        $correctLevelData = $lvl;
                    } else {
                        break;
                    }
                }
            }
            if ($correctLevelData && $item->level != $correctLevelData['id']) {
                $item->level = $correctLevelData['id'];
                // 重新绑定关联，确保后台显示的等级名称、图标等同步正确
                $item->setRelation('user_level', new \app\common\model\UserLevel($correctLevelData));
            }
        }
        // --- 校准后台列表等级结束 ---

        return $lists->toArray();
    }

    /**
     * @notes 统计数据
     * @return int
     */
    public function count(): int
    {
        return User::withSearch($this->setSearch(), $this->params)->count();
    }

    /**
     * @notes 设置excel表名
     * @return string
     */
    public function setFileName(): string
    {
        return '用户列表';
    }

    /**
     * @notes 设置导出字段
     * @return array
     */
    public function setExcelFields(): array
    {
        return [
            'sn'                    => '用户编号',
            'nickname'              => '用户昵称',
            'name'                  => '用户等级',
            'mobile'                => '手机号码',
            'total_user_money'      => '钱包余额',
            'total_order_amount'    => '消费金额',
            'login_time'            => '最后登录时间',
            'create_time'           => '注册时间',
        ];
    }
}