<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\circle;

use app\adminapi\controller\BaseAdminController;

use app\common\service\ConfigService;

/**
 * 圈子设置
 * Class TransactionSettingsController
 * @package app\adminapi\controller\settings\order
 */
class Circle extends BaseAdminController
{
    /**
     * @notes 获取话题设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        return [
            'circle_name'=>ConfigService::get('circle', 'circle_name','圈子'),
            'create_circle_price'=>ConfigService::get('circle', 'create_circle_price',0),
            'circle_profit_pct'=>ConfigService::get('circle', 'circle_profit_pct',0),
            'plugin_open_style'=>ConfigService::get('circle', 'plugin_open_style',0),
        ];
        // return $this->data($result);
    }

    /**
     * @notes 交易设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        ConfigService::set('circle', 'circle_name', $params['circle_name'] ?? '圈子');
        ConfigService::set('circle', 'create_circle_price', $params['create_circle_price'] ?? 0);
        ConfigService::set('circle', 'circle_profit_pct', $params['circle_profit_pct'] ?? 0);
        ConfigService::set('circle', 'plugin_open_style', $params['plugin_open_style'] ?? 0);
        return $this->success('设置成功');
    }
}