<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\service\FileService;
use think\model\concern\SoftDelete;


class Article extends BaseModel
{
    // use SoftDelete;
    // protected $deleteTime = 'delete_time';

    protected $json = ['city_json'];

    public function vipLevel()
    {
        return $this->hasOne(VipLevel::class,'id','vip_level_id');
    }

    /**
     * 用户的所有圈子等级
     */
    public function circleLevel()
    {
        return $this->hasMany(CircleLevel::class,'user_id','user_id');
    }

    public function chatGroup()
    {
        return $this->hasOne(ChatGroup::class,'id','chat_group_id');
    }
    
    /**
     * @notes 用户关联模型
     * @return \think\model\relation\HasOne
     * @author lgp
     * @date 2023/2/16 18:45
     */
    public function user()
    {
        return $this->hasOne(User::class,'id','user_id')->field('id,sn,nickname,avatar,level,mobile,sex');
    }

    public function goods()
    {
        return $this->hasOne(Goods::class,'id','goods_id')->field('id,name,type,image,min_price,max_price,min_lineation_price,max_lineation_price,total_stock,click_num,sales_num');
    }

    public function vote()
    {
        return $this->hasMany(Vote::class,'article_id','id')->with('options');
    }

    public function tradeArticleRedPackets()
    {
        return $this->hasMany(TradeArticleRedPackets::class,'article_id','id')->with(['redPackets']);
    }
    /**
     * @notes 圈子关联模型
     * @return \think\model\relation\HasOne
     * @author lgp
     * @date 2023/2/16 18:45
     */
    public function circle()
    {
        return $this->hasOne(Circle::class,'id','circle_id')->field('id,name,synopsis,icon,visit_level,edit_template,template');
    }

    public function subCategory()
    {
        return $this->hasOne(CircleSubCategory::class,'id','sub_category_id');
    }

    /**
     * @notes 话题关联模型
     * @return \think\model\relation\HasOne
     * @author lgp
     * @date 2023/2/16 18:45
     */
    public function topic()
    {
        return $this->hasOne(Topic::class,'id','topic_id')->field('id,name');
    }

    /**
     * @notes 公共处理图片,补全路径
     * @param $value
     * @return string
     */
    public function getImageAttr($value)
    {
        if(!$value){
            return '';
        }
        $data = [];
        $value = explode(',',$value);
        
        foreach( $value as $v){
            $data[]=FileService::getFileUrl($v);
        }
        return $data;
    }

        /**
     * @notes 公共处理视频,补全路径
     * @param $value
     * @return string
     */
    // public function getVideoAttr($value)
    // {
    //     // echo '视频b';die;
    //     // if(!$value){
    //     //     return '';
    //     // }
    //     // $data = [];
    //     // $value = explode(',',$value);
        
    //     // foreach( $value as $v){
    //     //     $data[]=FileService::getFileUrl($v);
    //     // }
    //     // return $data;
    // }


    /**
     * @notes 获取评论数
     */
    public function getCommentNumAttr($value ,$data)
    {
        return ArticleComment::where(['status' => 1 , 'aid' => $data['id']])->count();
    }
    
    /**
     * 获取投票数量
     */
    public function getVoteNumAttr($value,$data)
    {
        $votes = \app\common\model\Vote::where('article_id',$data['id'])->select()->toArray();

        foreach($votes as &$vote){
            $vote['count']=\app\common\model\VoteLog::where(['vote_id' => $vote['id']])->count();
        }

        return $votes;
    }

    /**
     * @notes 获取收藏数
     */
    public function getCollectNumAttr($value ,$data)
    {
        return UserCollect::where([ 'aid' => $data['id']])->where('type', 1)->count();
    }

    /**
     * @notes 获取点赞数
     */
    public function getZanNumAttr($value ,$data)
    {
        return UserCollect::where([ 'aid' => $data['id']])->whereIn('type' ,[2,3])->count();
    }

    /**
     * @notes 显示状态获取器
     * @param $value
     * @return string
     */
    public function getIsStatusDescAttr($value)
    {
        switch($value){
            case 1:
                return '正常';
                break;
            case 2:
                return '驳回';
                break;

        }
    }
}