<?php 
 /** 
  *  ╔═══════════════════════════════════════════════════╗ 
  *  ║                                                   ║ 
  *  ║     ██╗  ██╗   █████╗    ██████╗                  ║ 
  *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║ 
  *  ║     ███████║  ███████║  ██║   ██║                 ║ 
  *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║ 
  *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║ 
  *  ║                                                   ║    
  *  ║                                                   ║    
  *  ║     © 2023 HaoSNS™ All Rights Reserved            ║ 
  *  ║     官方网站: `https://www.haosns.com`                 * 
  *  ║     本代码由赣州乐易网络科技有限公司®提供             * 
  *  ║                                                    * 
  *  ║   未经授权禁止复制、传播或用于其他商业目的            * 
  *  ║                                                   ║ 
  *  ╚═══════════════════════════════════════════════════╝ 
  */ 
 
 namespace app\api\controller; 
 
 use app\api\logic\ArticleRedLogic;
 
 /** 
  * 红包配置控制器 
  * Class RedPacketConfigController 
  * @package app\api\controller 
  */ 
 class ArticleRedbag extends BaseShopController 
 { 
     public array $notNeedLogin = ['getConfig', 'getconfig', 'getRedModes', 'getredmodes']; 
 
     /** 
      * @notes 获取红包配置 
      * @return \think\response\Json 
      */ 
     public function getConfig() 
     { 
         $config = ArticleRedLogic::getConfig();

         if ($this->request->get('debug')) {
             return $this->success('', [
                 'config' => $config,
                 'request' => [
                     'controller' => $this->request->controller(),
                     'action' => $this->request->action(),
                     'pathinfo' => $this->request->pathinfo(),
                     'method' => $this->request->method(),
                     'get' => $this->request->get(),
                     'header' => $this->request->header(),
                 ],
             ]);
         }
         return $this->success('', $config); 
     } 

     public function getRedModes()
     {
         try {
             $data = ArticleRedLogic::parseRedMode();
             return $this->success('', $data);
         } catch (\Exception $e) {
             return $this->fail($e->getMessage());
         }
     }
 }