<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\enum\WithdrawEnum;
use app\common\service\FileService;
use think\model\concern\SoftDelete;

/**
 * 提现模型
 * Class WithdrawApply
 * @package app\common\model
 */
class WithdrawApply extends BaseModel
{
    use SoftDelete;

    protected $deleteTime = 'delete_time';

    /**
     * @notes 类型获取器
     * @param $value
     * @return string|string[]
     */
    public function getTypeDescAttr($value)
    {
        return WithdrawEnum::getTypeDesc($value);
    }

    /**
     * @notes 状态获取器
     * @param $value
     * @return string|string[]
     */
    public function getStatusDescAttr($value)
    {
        return WithdrawEnum::getStatusDesc($value);
    }

    /**
     * @notes 转账凭证
     * @param $value
     * @return string|string[]
     * @author lgp
     * @date 2022/3/17 10:57
     */
    public function getTransferVoucherAttr($value){
        if($value){
            return FileService::getFileUrl($value);
        }
        return $value;
    }

    /**
     * @notes 转账时间
     * @param $value
     * @return false|string
     * @author lgp
     * @date 2022/3/17 11:26
     */
    public function getTransferTimeAttr($value){
        if($value){
            return date('Y-m-d H:i:s',$value);
        }
        return $value;
    }
}