<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
declare (strict_types = 1);

namespace app\common\model;

use think\Model;

/**
 * @mixin \think\Model
 */
class ChatTemp extends Model
{
    use \think\model\concern\SoftDelete;
    protected $deleteTime = 'delete_time';
    
    public function toUser()
    {
        return $this->hasOne(User::class, 'id', 'to_id')->field('id,nickname,avatar');
    }

    public function group()
    {
        return $this->hasOne(ChatGroup::class, 'id', 'group_id');
    }

    public function groupMembers()
    {
        return $this->hasMany(ChatGroupMember::class,'group_id','group_id')->with('user');
    }

    public function circle()
    {
        return $this->hasOne(Circle::class,'id','circle_id');
    }
}
