<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\listener\websocket;

use app\common\model\ChatMessage;
use app\common\model\ChatRelation;
use app\common\model\ChatTemp;

/**
 * 已读状态
 * Class Read
 * @package app\common\listener\websocket
 */
class Read
{
    public function handle($params)
    {
        $fromFd = $params['fd'];
        $requestData = $params['data'];
        $handleClass = $params['handle'];
        $fromData = $handleClass->getDataByFd($fromFd);

        if($params['data']['type']='private_chat'){
            // 私聊内容已读
            $update_whre = ['from_id' =>$requestData['to_id'],'to_id'=>$fromData['uid']];
            ChatMessage::update(['is_read' => 1], $update_whre);

            // 对方用户增加一条未读消息
            ChatTemp::update(['unread'=>0],['user_id'=>$fromData['uid'],'to_id'=>$requestData['to_id']]);
        }else{
            // 群聊内容已读
            echo '已读群消息'.$requestData['group_id'];
            ChatTemp::update(['unread'=>0],['group_id'=>$requestData['group_id'],'user_id'=>$fromData['uid']]);
        }
        
    }
}