<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\enum;
class DiscountEnum
{

    const DISCOUNT_JOIN =  1;
    const DISCOUNT_NOT_JOIN = 0;


    const DISCOUNT_RULE_LEVEL   = 1;
    const DISCOUNT_RULE_DIY     = 2;

    /**
     * @notes 获取折扣状态
     * @param bool $from
     * @return array|mixed|string
     * @author lgp
     * @date 2022/5/9 19:05
     */
    public static function getDiscountStatusDesc($from =true){
        $desc = [
            self::DISCOUNT_JOIN     => '参与',
            self::DISCOUNT_NOT_JOIN => '不参与',

        ];

        if(true === $from){
            return $desc;
        }
        return $desc[$from] ?? '';
    }

}