<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\validate\twoshop;

use app\common\validate\BaseValidate;

/**
 * 售后验证器
 * Class AfterSaleValidate
 * @package  app\api\validate
 */
class AfterSaleValidate extends BaseValidate
{
    protected $rule = [
        'refund_method' => 'require|in:1,2',
        'refund_reason' => 'require',
        'order_id' => 'require',
        'id' => 'require',
        'express_name' => 'require',
        'invoice_no' => 'require',
        'type' => 'require',
        'voucher' => 'array|checkCount',
    ];

    protected $message = [
        'refund_method.require' => '请选择售后方式',
        'refund_method.in' => '售后方式错误',
        'refund_reason.require' => '请输入退款原因',
        'order_id.require' => '请提供订单ID',
        'id.require' => '参数缺失',
        'express_name.require' => '请填写快递公司',
        'invoice_no.require' => '请填写物流单号',
        'type.require' => '请选择列表类型',
        'voucher.array' => '凭证须为数组格式',
    ];

    /**
     * @notes 获取子订单商品信息场景
     * @return AfterSaleValidate
     */
    public function sceneOrderGoodsInfo()
    {
        return $this->only(['order_id', 'refund_method'])
            ->remove('refund_method', 'require');
    }

    /**
     * @notes 申请商品售后场景
     */
    public function sceneApply()
    {
        return $this->only(['refund_method', 'refund_reason', 'order_id', 'voucher']);
    }

    /**
     * @notes 买家取消售后场景
     * @return AfterSaleValidate
     */
    public function sceneCancel()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 买家确认退货场景
     * @return AfterSaleValidate
     */
    public function sceneReturnGoods()
    {
        return $this->only(['id', 'express_name', 'invoice_no']);
    }

    /**
     * @notes 列表场景
     * @return AfterSaleValidate
     */
    public function sceneLists()
    {
        return $this->only(['type']);
    }

    /**
     * @notes 售后详情场景
     * @return AfterSaleValidate
     */
    public function sceneDetail()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 凭证数量限制
     * @param $voucher
     * @return bool|string
     */
    public function checkCount($voucher)
    {
        if (count($voucher) > 3) {
            return '最多上传3张凭证';
        }
        return true;
    }
}