<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\logic;

use app\common\enum\NoticeEnum;
use app\common\logic\BaseLogic;
use app\common\model\UserFollow;

/**
 * 用户其他逻辑层
 * Class CollectLogic
 * @package app\common\logic
 */
class UserExtendLogic extends BaseLogic
{

    /**
     * @notes 用户关注
     * @param array $params
     * @param int $userId
     * @return bool
     */
    public function handleUserFollow(array $params,int $userId)
    {
        if (!isset($params['is_follow']) ) {
            return '参数缺失';
        }
        if($userId == $params['user_id']){
            return '不能关注自己';
        }
        
        if($params['is_follow']){
            $goodsCollect = UserFollow::
                        where(['follow_user_id'=>$params['user_id'],'user_id'=>$userId])
                        ->findOrEmpty();

            if(!$goodsCollect->isEmpty()){
                return true;
            }
            $goodsCollect->follow_user_id = $params['user_id'];
            $goodsCollect->user_id  = $userId;
            $goodsCollect->save();

            // 消息通知
            event('Notice', [
                'scene_id' => NoticeEnum::FOLLOW_NOTICE,
                'params' => [
                    'fans_id' => $userId,
                    'user_id' => $params['user_id']
                ]
            ]);

            return true;
        }
        //删除
        UserFollow::destroy(['follow_user_id'=>$params['user_id'],'user_id'=>$userId]);
        return true;
    }
    




}