<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\lists;

use app\common\model\TwoGoodsMessage;
use app\common\model\UserCollect;

class TwoGoodsMessageLists extends BaseShopDataLists  
{
    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch()
    {
        
        $this->searchWhere = [];
        $this->searchWhere[] = [
            'status' ,'=' , 1
        ];

        if (isset($this->params['user_id']) && $this->params['type'] != 3) {
            $this->searchWhere[] = [
                'user_id' ,'=' , $this->params['user_id']
            ];
        }

        if (isset($this->params['type'])) {
            if ($this->params['type'] == 2) {
                //
            }

            if ($this->params['type'] == 3) {
                $this->searchWhere[] = [
                    'user_id' ,'!=' , $this->params['user_id']
                ];
            }
        }

        if (isset($this->params['id'])) {
            $this->searchWhere[] = [
                'goods_id' ,'=' , $this->params['id']
            ];
        }
        
        if (isset($this->params['article_id'])  && $this->params['article_id'] ) {
            $this->searchWhere[] = [
                'aid' ,'=' , $this->params['article_id']
            ];
        }

        
        
    }

    /**
     * @notes 留言列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $this->setSearch();
        $lists = \app\common\model\TwoGoodsMessage::with(['user'])->where($this->searchWhere)
            ->where(['pid' => 0])
            ->order('create_time asc,id asc')
            ->append(['collect_num'])
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();

        foreach($lists as  &$item){

            $item['create_time'] = formatTime($item['create_time']);
            
            // if($this->userId) {
            //     //是否点赞过
            //     $isCollect = UserCollect::where([ 'type' => 3, 'comments_id' => $item['id'], 'goods_id' => $item['goods_id'], 'user_id' => $this->userId])->value('id');
            //     $item['is_collect'] = $isCollect ? 1 : 0;
            // }
            // 获取子评论
            $replyList = \app\common\model\TwoGoodsMessage::with(['user'])->where($this->searchWhere)
                ->where(['pid' => $item['id']])
                ->order('create_time asc,id asc')
                ->append(['collect_num'])
                ->limit($this->limitOffset, $this->limitLength)
                ->select()
                ->toArray();
            // dd($replyList);
            foreach($replyList as &$ritem){

                // if($this->userId) {
                //     //是否点赞过
                //     $isCollect = UserCollect::where([ 'type' => 3, 'comments_id' => $ritem['id'], 'aid' => $ritem['aid'], 'user_id' => $this->userId])->value('id');
                //     $ritem['is_collect'] = $isCollect ? 1 : 0;
                // }
            }
            $item['replyList'] = $replyList;

        }

        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        $this->setSearch();
        return \app\common\model\TwoGoodsMessage::where($this->searchWhere)->where(['pid' => 0])->count();
    }
}