<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\model\RechargeTemplate;

/**
 * 充值模板列表
 * Class RechargeTemplateLists
 * @package app\api\lists
 */
class RechargeTemplateLists extends BaseShopDataLists
{
    /**
     * @notes 充值模板列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $lists = RechargeTemplate::field('id,money,award')->select()->toArray();
        foreach($lists as &$item) {
            $item['tips'] = $this->getTips($item);
        }

        return $lists;
    }

    /**
     * @notes 充值模板数理
     * @return int
     */
    public function count(): int
    {
        $count = RechargeTemplate::count();

        return $count;
    }

    /**
     * @notes 获取充值赠送提示语
     * @param $item
     * @return string
     */
    public function getTips($item)
    {
        if(empty($item['award']) || !is_array($item['award'])) {
            return '';
        }
        foreach($item['award'] as $subItem) {
            return isset($subItem['give_money']) && $subItem['give_money'] > 0 ? '充' . $item['money'] . '送' . clear_zero($subItem['give_money']) . '元' : '';
        }
    }
}