<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\lists\ListsSearchInterface;
use app\common\model\User;
use app\common\service\ConfigService;
use app\common\service\FileService;

class InviterLists extends BaseShopDataLists implements ListsSearchInterface
{
    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch(): array
    {
        return [
            ['inviter_id', '=', $this->userId],
            ['disable', '=',0],

        ];
    }

    /**
     * @notes 列表
     * @return array
     */
    public function lists(): array
    {
        $lists = User::where($this->setSearch())
            ->order('id desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->field('id,sn,nickname,create_time')
            ->select()
            ->toArray();

        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        return User::where($this->setSearch())->count();
    }
}