<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\api\controller\twoshop;


class GoodsReport extends \app\api\controller\BaseShopController
{

    public function types()
    {
        $list = \app\common\model\TwoGoodsReportType::select();

       return show(1,'举报类型',$list);
    }

    public function my() {
        $list = \app\common\model\TwoGoodsReport::where('user_id', $this->userId)->select();

       return show(1,'我的举报',$list);
    }

    public function detail($id) {
        $item = \app\common\model\TwoGoodsReport::where('id', $id)->find();

        if($item){
            return show(1,'查询成功',$item);
        }else{
            return show(0,'查询失败');
        }
    }

    public function submit() {
        $goods_id = $this->request->post('id');
        $type_id = $this->request->post('type_id');
        $content = $this->request->post('content');
        $image = $this->request->post('image');

        if (empty($goods_id)) {
            return show(0, '请选择要举报的商品');
        }

        $goods = \app\common\model\TwoGoods::find($goods_id);

        if (!$goods) {
            return show(0, '要举报的商品不存在');
        }

        if (empty($type_id)) {
            return show(0, '请选择举报类型');
        }

        if (empty($content)) {
            return show(0, '请输入举报内容');
        }

        \app\common\model\TwoGoodsReport::create([
            'user_id' => $this->userId,
            'goods_id' => $goods->id,
            'seller_user_id' => $goods->user_id,
            'type_id' => $type_id,
            'content' => $content,
            'image' => $image
        ]);

        return show(1, '提交成功');
    }

}