<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller\twoshop;

use app\common\service\ConfigService;

/**
 * 配置
 */
class Config extends \app\api\controller\BaseShopController
{
   public array $notNeedLogin = ['get'];

   public function get() {
    return show(1,'获取成功', [
        'name'=>ConfigService::get('twoshop', 'name', '二手商城'),
        'must_verified_type_id'=>ConfigService::get('twoshop', 'must_verified_type_id', 0),
        'min_promise_money'=>ConfigService::get('twoshop', 'min_promise_money', 0)
    ]);
   }
}
