<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\api\controller\twoshop;
use app\api\{
    logic\twoshop\CollectLogic,
    // lists\GoodsCollectLists
};


/**
 * 收藏控制器
 * Class CollectController
 * @package app\api\controller
 */
class Collect extends \app\api\controller\BaseShopController
{

    /**
     * @notes 收藏列表
     * @return \think\response\Json
     */
    public function list()
    {
        $list = \app\common\model\TwoGoodsCollect::where('user_id',$this->userId)
        ->where('type',input('type')) // 1=收藏，2=点赞
        ->with(['goods', 'goods.user'])
        ->order('create_time','desc')
        ->paginate(10);

       return show(1,'商品收藏',$list);
    }

    /**
     * @notes 操作收藏
     * @return \think\response\Json
     */
    public function handleCollectgoods()
    {
        $params = $this->request->post();
        $result = (new CollectLogic)->handleCollectGoods($params,$this->userId);
        if ($result === true) {
            $tips = $params['is_collect'] ? '操作成功' : '取消成功';
            return $this->success($tips,[]);
        }
        return $this->fail($result);
    }

}