<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\api\controller\pointsshop;

use think\facade\Db;

class Goods extends \app\api\controller\BaseShopController
{
    public array $notNeedLogin = ['search'];

    /**
     * 商品搜索
     */
    public function search()
    {
        $params = $this->request->param();
        $order = [
            'sort'=>'desc'
        ];
        $where = [
            ['status','=',1]
        ];

        if(isset($params['name'])){
            $where[]=['name','like','%'.$params['name'].'%'];
        }
        
        if(isset($params['order_by'])){
            $order[$params['order_by']]='desc';
        }
        if(isset($params['order_sort'])){
            $order[$params['order_by']]=$params['order_sort'];
        }

    //     if(isset($params['category_id'])){
    //         $where[]=['category_id','=',$params['category_id']];
    //     }

        $list = \app\common\model\PointsGoods::where($where)
        ->order($order)
        ->paginate(10);

       return show(1,'积分商品',$list);
    }

    /**
     * @note 商品详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params =  $this->request->get();
        $params['user_id'] = $this->userId;
        $detail = \app\common\model\PointsGoods::find($params['id']);
        if (!$detail) {
            return show(0,'查询失败');
        }
        return show(1,'商品详情',$detail);
    }

    /* 
    *商品添加接口
    */
    public function add()
    {
        // $params = $this->request->post();
        // $params['user_id'] = $this->userId;
        // if ($params['spec_type'] == 2) {
        //     $params['server_spec_value_list'] = cartesian_product(array_converting(array_column($params['spec_value'],'spec_list')));
        // }

        // (new \app\api\validate\twoshop\GoodsValidate())->post()->goCheck('add');              //商品基础信息验证
        // (new \app\api\validate\twoshop\GoodsItemValidate())->post()->goCheck('', $params);    //商品规格验证
        
        // Db::startTrans();
        // try {
        //     // 添加商品
        //     $goods = $this->setBase($params);
        //     // 添加商品的规格
        //     $this->addGoodsItem($goods,$params);
        //     // 记录店铺动态
        //     \app\common\model\TwoGoodsLog::create([
        //         'user_id'=>$params['user_id'],
        //         'goods_id'=>$goods->id,
        //         'name'=>$goods->name,
        //         'image'=>$goods->image,
        //         'price'=>$goods->min_price,
        //         'desc'=>'上新了1件宝贝',
        //     ]);

        //     Db::commit();
        //     return show(1,'添加成功');
        // } catch (\Exception $e) {
        //     Db::rollback();
        //     return show(0,$e->getMessage());
        // }
    }



    /**
     * 根据商品查询商品评论
     */
    public function goodsCommentList()
    {
        // $params = $this->request->get();
        // // 查询订单是否已收获
        // $data = \app\common\model\TwoGoodsComment::with('user')
        // ->where([
        //     ['goods_id','=',$params['goods_id']],
        //     ['status','=',1]
        // ])
        // ->order(['id'=>'desc','create_time'=>'desc'])
        // ->paginate(10);
        // return show(1,'商品评论列表',$data);
    }

}