<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;

use app\api\lists\ArticleVisitLists;
use app\api\lists\FansLists;
use app\api\lists\FollowLists;
use app\api\lists\InviterLists;
use app\api\logic\UserExtendLogic;
use app\common\model\ChatPrivateMessage;



/**
 * 用户其他控制器
 * Class CollectController
 * @package app\api\controller
 */
class UserExtend extends BaseShopController
{
    public function search()
    {
        $params = $this->request->param();
        $fields = 'id,nickname,`desc`,avatar,sex,birthday,images,ip_address,home_bg,birth';
        
        $user = (new \app\common\model\User)->with(['label'])->field($fields);
        
        if (isset($params['type'])) {
            switch($params['type']) {
                case 'online':
                    $ids=[];
                    $prefix = 'user_online_';
                    foreach (\think\facade\Cache::store('redis')->handler()->keys("$prefix*") as $i => $id) {
                        $id = str_replace($prefix, '', $id);

                        if (checkOnline($id)['status']) {
                            $ids[] = $id;
                        }
                    }
                    $user = $user->where([
                        ['id', 'in', $ids]
                    ]);
                    break;
                case 'near':
                    if (!isset($params['latitude']) && isset($params['longitude'])) {
                        return show(0,'参数错误');
                    }

                    $longitude = $params['longitude'];
                    $latitude = $params['latitude'];

                    $user = $user->whereNotNull('longitude')
                        ->whereNotNull('latitude')
                        ->field("$fields,longitude,latitude,".get_distance_sql($longitude,$latitude))
                        ->order('distance asc');
                    break;
                case 'latest':
                    $user = $user->order('create_time desc');
                    break;
            }
        }

        $data = $user->paginate()->toArray();

        foreach($data['data'] as &$item) {
            $item['online'] = checkOnline($item['id']);
            $lastMessage = ChatPrivateMessage::where('from_id', $this->userId)
                ->where('to_id', $item['id'])
                ->where('msg_type', 'in', ['text', 'image'])
                ->findOrEmpty()
                ->toArray();

            if ($lastMessage) {
                $item['last_message'] = $lastMessage['msg_type'] === 'image' ? '[图片]' : $lastMessage['msg'];
            } else {
                $item['last_message'] = '';
            }
        }

        return show(1,'用户搜索',$data);
    }
    
    /**
     * @notes 粉丝列表
     * @return \think\response\Json
     */
    public function fans()
    {
        return $this->dataLists((new FansLists()));
    }


    /**
     * @notes 关注列表
     * @return \think\response\Json
     */
    public function follow()
    {
        return $this->dataLists((new FollowLists()));
    }

    /**
     * @notes 操作关注
     * @return \think\response\Json
     */
    public function handleUserFollow()
    {
        $params = $this->request->post();
        $result = (new UserExtendLogic)->handleUserFollow($params,$this->userId);
        if ($result === true) {
            $tips = $params['is_follow'] ? '关注成功' : '取消关注';
            return $this->success($tips,[]);
        }
        return $this->fail($result);

    }



    /**
     * @notes 浏览列表
     * @return \think\response\Json
     */
    public function visit()
    {
        return $this->dataLists((new ArticleVisitLists()));
    }


    /**
     * @notes 邀请列表
     * @return \think\response\Json
     */
    public function inviter()
    {
        return $this->dataLists((new InviterLists()));
    }

    


}