<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\common\enum\NoticeEnum;
use app\api\logic\RegisterLogic;
use app\api\validate\RegisterValidate;

/**
 * 注册控制器
 * Class RegisterController
 * @package app\api\controller
 */
class Register extends BaseShopController
{
    public array $notNeedLogin = ['captcha', 'register'];

    /**
     * @notes 发送验证码 - 注册
     */
    public function captcha()
    {
        $params = (new RegisterValidate())->post()->goCheck('captcha');
        $code = mt_rand(1000, 9999);
        $result = event('Notice', [
            'scene_id' => NoticeEnum::REGISTER_CAPTCHA,
            'params' => [
                'mobile' => $params['mobile'],
                'code' => $code,
            ]
        ]);

        if ($result[0] === true) {
            return $this->success('发送成功');
        }

        return $this->fail($result[0], [], 0, 1);
    }

    /**
     * @notes 手机号注册
     * @return \think\response\Json
     */
    public function register()
    {
        $params = (new RegisterValidate())->post()->goCheck('register');
        $result = \app\api\logic\RegisterLogic::register($params);
        if($result) {
            // 记录注册日志
            \app\common\model\UserLog::create([
                'user_id'=>$result->id,
                'ip'=>$this->request->ip(),
                'remark'=>'手机号注册',
                'code'=>'register',
                'text'=>json_encode($_SERVER,true),
            ]);

            return $this->success('注册成功', [], 1, 1);
        }
        
        return $this->fail(RegisterLogic::getError());
    }
}